/**
 * Simple Read
 * 
 * Read data from the serial port and change the color of a rectangle
 * when a switch connected to a Wiring or Arduino board is pressed and released.
 * This example works with the Wiring / Arduino program that follows below.
 */


import processing.serial.*;

Serial myPort;  // Create object from Serial class
int val;      // Data received from the serial port
float hor;
float ver;
float sizeA1;
float sizeA2;
float sizeB1;
float sizeB2;
float hor1;
float hor2;
float ver1;
float ver2;


void setup() 
{

  fullScreen();
  //size(400, 500);
  // I know that the first port in the serial list on my mac
  // is always my  FTDI adaptor, so I open Serial.list()[0].
  // On Windows machines, this generally opens COM1.
  // Open whatever port is the one you're using.
  //String myPort = Serial.list()[1];
  //println(Serial.list());
  myPort = new Serial(this, "/dev/cu.usbserial-FT9L0OK5", 4800);

  //visual
  hor = 400/3;
  hor1 = 400/3;
  hor1=hor2;

  ver1 = 125;
  ver1=ver2;

  sizeA1 = 250;
  sizeA2 = sizeA1;

  sizeB1 = 180;
  sizeB2 = sizeB1;
}

void draw()
{
  // Expand array size to the number of bytes you expect
  byte[] inBuffer = new byte[7];

  if ( myPort.available() > 0) {  // If data is available,
    inBuffer = myPort.readBytes();
    myPort.readBytes(inBuffer);
    if (inBuffer != null) {
      String myString = new String(inBuffer);
      println(myString);

      //drawing
      background(0);
      stroke(51, 0, 153);
      strokeWeight(2);
      noFill();

      sizeA1 = random(180, 250);
      sizeA2 = sizeA1;

      sizeB1 = random(110, 180);
      sizeB2 = sizeB1;


      ellipse(hor1, 125, sizeA1, sizeA2);
      delay(20);
      ellipse(2*hor2, 125, sizeA1, sizeA2);
      delay(30);
      ellipse(hor1, 375, sizeA1, sizeA2);
      delay(20);
      ellipse(2*hor2, 375, sizeA1, sizeA2); 

      delay(30);

      ellipse(400/3, ver1, sizeB1, sizeB2);
      delay(40);
      ellipse(800/3, ver2, sizeB1, sizeB2);

      delay(10);

      sizeA1 = sizeA1-+sizeA1*random(0, 1);
      sizeB1 = sizeB1-+sizeB1*random(0, 1);

      hor1 = hor1 - random(10, 20);
      hor2 = hor2 + random(10, 20);

      ver1= ver1 + random(10, 20);
      ver2= ver2 - random(10, 20);
    }
  } else {
    
    background(0);
    stroke(203, 109, 81);
    strokeWeight(2);
    noFill();

    sizeA1 = random(180, 250);
    sizeA2 = sizeA1;

    sizeB1 = random(110, 180);
    sizeB2 = sizeB1;


    ellipse(hor, 125, sizeA1, sizeA2);
    delay(20);
    ellipse(2*hor, 125, sizeA1, sizeA2);
    delay(30);
    ellipse(hor, 375, sizeA1, sizeA2);
    delay(20);
    ellipse(2*hor, 375, sizeA1, sizeA2); 

    delay(30);

    ellipse(hor, 250, sizeB1, sizeB2);
    delay(40);
    ellipse(2*hor, 250, sizeB1, sizeB2);

    delay(10);
   ;

    //Movement
    sizeA1 = sizeA1-+sizeA1*random(0, 1);
    sizeB1 = sizeB1-+sizeB1*random(0, 1);
  }

  //background(255);             // Set background to white
  /*if (val >= 800) {              // If the serial value is 0,
   stroke(51, 0, 153);
   noFill();
   ellipse(400/3,125,250,250);
   ellipse(800/3,125,250,250);
   ellipse(400/3,375,250,250);
   ellipse(800/3,375,250,250); 
   ellipse(400/3,250,180,180);
   ellipse(800/3,250,180,180);// set fill to black
   } 
   else {
   fill(51, 0, 153);// If the serial value is not 0,
   stroke(0);
   ellipse(width-mouseX,height-mouseY,180,180);
   fill(0);
   stroke(51, 0, 153);
   ellipse(mouseX,mouseY,180,180);               // set fill to light gray
   }
   */
}



/*

 // Wiring / Arduino Code
 // Code for sensing a switch status and writing the value to the serial port.
 
 int switchPin = 4;                       // Switch connected to pin 4
 
 void setup() {
 pinMode(switchPin, INPUT);             // Set pin 0 as an input
 Serial.begin(9600);                    // Start serial communication at 9600 bps
 }
 
 void loop() {
 if (digitalRead(switchPin) == HIGH) {  // If switch is ON,
 Serial.write(1);               // send 1 to Processing
 } else {                               // If the switch is not ON,
 Serial.write(0);               // send 0 to Processing
 }
 delay(100);                            // Wait 100 milliseconds
 }
 
 */
