
/*---debug Pin Setup---*/
int debug_pin = A0; 

/*---Wire Setup---*/
#include <Wire.h>

/*---RFID Reader Setup---*/
#include <SPI.h>
#include <MFRC522.h>
constexpr uint8_t RST_PIN = 9;          // Configurable, see typical pin layout above
constexpr uint8_t SS_PIN = 10;         // Configurable, see typical pin layout above
MFRC522 mfrc522(SS_PIN, RST_PIN);  // Create MFRC522 instance

/*---NeoPixel Setup---*/
#include <Adafruit_NeoPixel.h>
#ifdef __AVR__
#include <avr/power.h>
#endif
// Which pin on the Arduino is connected to the NeoPixels?
#define PIN            A1
// How many NeoPixels are attached to the Arduino?
#define NUMPIXELS      1
// When we setup the NeoPixel library, we tell it how many pixels, and which pin to use to send signals.
Adafruit_NeoPixel pixels = Adafruit_NeoPixel(NUMPIXELS, PIN, NEO_GRB + NEO_KHZ800);

void setup() {
  /*---debug_pin Initialisation ---*/
  pinMode(debug_pin, OUTPUT);
  digitalWrite(debug_pin, HIGH);
  delay (300);
  digitalWrite(debug_pin, LOW);
  delay (300);
  digitalWrite(debug_pin, HIGH);
  delay (300);
  digitalWrite(debug_pin, LOW);
  delay (300);
  digitalWrite(debug_pin, HIGH);
  delay (300);

  /*---Serial Initialisation---*/
	Serial.begin(9600);		// Initialize serial communications with the PC
	while (!Serial);		// Do nothing if no serial port is opened (added for Arduinos based on ATMEGA32U4)

  /*---RFID Reader Initialisation---*/
	SPI.begin();			// Init SPI bus
	mfrc522.PCD_Init();		// Init MFRC522
	mfrc522.PCD_DumpVersionToSerial();	// Show details of PCD - MFRC522 Card Reader details
	Serial.println(F("Scan PICC to see UID, SAK, type, and data blocks..."));

  /*---NeoPixel Initialisation---*/
  pixels.begin(); // This initializes the NeoPixel library.
}

void loop() {
	
  // NeoPixel Turns Blue
     pixels.setPixelColor(0, pixels.Color(0, 0, 150)); // blue color.
     pixels.show(); 
  
	// Look for new cards
	if ( ! mfrc522.PICC_IsNewCardPresent()) {
		return;
	}

	// Select one of the cards
	if ( ! mfrc522.PICC_ReadCardSerial()) {
		return;
	}

  // Check for Tag 1 (red shell)
  if (mfrc522.uid.uidByte[0] == 0x65 && 
     mfrc522.uid.uidByte[1] == 0x2E &&
     mfrc522.uid.uidByte[2] == 0x90 &&
     mfrc522.uid.uidByte[3] == 0x9D) {
      // Open kit 1
       Wire.beginTransmission(0x1); // transmit to device #1
       Wire.write(1);     // sends one byte
       Serial.println("1 sent to #1");
       Wire.endTransmission();    // stop transmitting  
       // NeoPixel Turns Green
       pixels.setPixelColor(0, pixels.Color(0, 150, 0)); // green color.
       pixels.show(); // This sends the updated pixel color to the hardware.
       delay(3000);

    } else 

  // Check for Tag 2 (blue shell)
  if (mfrc522.uid.uidByte[0] == 0x17 && 
     mfrc522.uid.uidByte[1] == 0xA9 &&
     mfrc522.uid.uidByte[2] == 0x25 &&
     mfrc522.uid.uidByte[3] == 0xD9) {
       // Open kit 1
       Wire.beginTransmission(0x1); // transmit to device #1
       Wire.write(1);     // sends one byte
       Serial.println("1 sent to #1");
       Wire.endTransmission();    // stop transmitting 
       // Open kit 2
       Wire.beginTransmission(0x2); // transmit to device #1
       Wire.write(1);     // sends one byte
       Serial.println("1 sent to #2");
       Wire.endTransmission();    // stop transmitting 
       // NeoPixel Turns Yellow
       pixels.setPixelColor(0, pixels.Color(0, 150, 0)); // green color.
       pixels.show(); // This sends the updated pixel color to the hardware.
       delay(3000);

    } else {
       // The tag is not recognised
       //NeoPixel Turns Red
     pixels.setPixelColor(0, pixels.Color(150, 0, 0)); // green color.
     pixels.show(); // This sends the updated pixel color to the hardware.
     delay(3000);
     }


}
