
/*---setup pin---*/
int feedback_pin = A0; // led for visual feedback

/*---Setup Tinywire---*/
#include <TinyWire.h>
byte own_address = 0x2;

/*---Setup SerialServo---*/
#include <SoftwareServo.h> 
SoftwareServo myservo;  // create servo object to control a servo 
int pos = 0;    // variable to store the servo position 

/*---Setup function to check if kit is Open or Not---*/
bool kitOpen = false; //by default, kit is closed
int kit_feedback_pin = A1; // led for visual feedback



void setup() {
  
  /*---led_pins Initialisation---*/
  pinMode(kit_feedback_pin, OUTPUT);
  pinMode(feedback_pin, OUTPUT);
  digitalWrite(kit_feedback_pin, HIGH);
  digitalWrite(feedback_pin, HIGH);
  delay(1000);
  digitalWrite(kit_feedback_pin, LOW);
  digitalWrite(feedback_pin, LOW);
  delay(1000);
  digitalWrite(kit_feedback_pin, HIGH);
  digitalWrite(feedback_pin, HIGH);
  delay(1000);
  digitalWrite(kit_feedback_pin, LOW);
  digitalWrite(feedback_pin, LOW);
  delay(1000);
  digitalWrite(feedback_pin, HIGH);


  /*---MyServo Initialisation---*/
  myservo.attach(7);  // attaches the servo on pin 7 
  
  /*---config TinyWire library for I2C slave functionality---*/
  TinyWire.begin( own_address );
  // sets callback for the event of a slave receive
  TinyWire.onReceive( onI2CReceive );
}

void loop() {
  if (kitOpen == true) { //is kit open?
  digitalWrite(kit_feedback_pin, HIGH); //switch led on
  myservo.write(180);                  //open iris 
      delay(15);                           // waits for the servo to get there 
      SoftwareServo::refresh();
    } else {
   digitalWrite(kit_feedback_pin, LOW); //switch led off
    myservo.write(1);                  // close or keep iris closed
      delay(15);                           // waits for the servo to get there 
      SoftwareServo::refresh();  
    }
}

/*
I2C Slave Receive Callback:
Note that this function is called from an interrupt routine and shouldn't take long to execute
*/
void onI2CReceive(int howMany){
  
  while(TinyWire.available()>0){// loops, until all received bytes are read
    
    if(TinyWire.read()==1){
      kitOpen = !kitOpen; // open or close kit
    }
  }
}



