

#include <TinyWire.h>

// constants won't change. They're used here to set pin numbers:
const int buttonPin = 3;     // the number of the pushbutton pin
const int ledPin =  1;      // the number of the LED pin

// variables will change:
int buttonState = 0;         // variable for reading the pushbutton status

byte slave_address = 10;


void setup() {

  // initialize the LED pin as an output:
  pinMode(ledPin, OUTPUT);

  // initialize the pushbutton pin as an input:
  pinMode(buttonPin, INPUT);
	
	// config TinyWire library for I2C master functionality
	TinyWire.begin();
}

void loop() {

  // read the state of the pushbutton value:
  buttonState = digitalRead(buttonPin);

  // check if the pushbutton is pressed. If it is, the buttonState is HIGH:
  if (buttonState == HIGH) {
    // turn LED on:
    digitalWrite(ledPin, HIGH);
    // begin a master transmission with the slave's address as parameter
    TinyWire.beginTransmission(slave_address);
    // fill the send buffer with bytes
    TinyWire.send(1);
    
  } else {
    // turn LED off:
    digitalWrite(ledPin, LOW);
  }
   
    delay(300);
}
