

#include <TinyWire.h>

const int ledPin =  1;      // the number of the LED pin

byte own_address = 10;


void setup() {
	// config led_pin as Output for driving an LED
	pinMode(ledPin, OUTPUT);
	
	// config TinyWire library for I2C slave functionality
	TinyWire.begin( own_address );
	// sets callback for the event of a slave receive
	TinyWire.onReceive( onI2CReceive );

  //testLED
    // turn LED on:
    digitalWrite(ledPin, HIGH);
    delay(300);
    // turn LED off:
    digitalWrite(ledPin, LOW);
    delay(300);
    // turn LED on:
    digitalWrite(ledPin, HIGH);
    delay(300);
    // turn LED off:
    digitalWrite(ledPin, LOW);
    delay(300);
    // turn LED on:
    digitalWrite(ledPin, HIGH);
    delay(300);
    // turn LED off:
    digitalWrite(ledPin, LOW);
    delay(300);
  
}

void loop() {
	
}

/*
I2C Slave Receive Callback:
Note that this function is called from an interrupt routine and shouldn't take long to execute
*/

void onI2CReceive(int howMany){
	// loops, until all received bytes are read
	while(TinyWire.available()>0){
    
		// toggles the led everytime, when an 'c' is received
		if(TinyWire.read()==1) {
      // turn LED on:
      digitalWrite(ledPin, HIGH);
      } else {
      // turn LED off:
      digitalWrite(ledPin, LOW);
    }
	}
}

