#include <Wire.h>

//NeoPixel Setup
#include <Adafruit_NeoPixel.h>
#ifdef __AVR__
#include <avr/power.h>
#endif

// Which pin on the Arduino is connected to the NeoPixels?
// On a Trinket or Gemma we suggest changing this to 1
#define PIN            6

// How many NeoPixels are attached to the Arduino?
#define NUMPIXELS      1

// When we setup the NeoPixel library, we tell it how many pixels, and which pin to use to send signals.
// Note that for older NeoPixel strips you might need to change the third parameter--see the strandtest
// example for more information on possible values.
Adafruit_NeoPixel pixels = Adafruit_NeoPixel(NUMPIXELS, PIN, NEO_GRB + NEO_KHZ800);

int delayval = 100; // delay for half a second

#include <Wire.h>

void setup() {
  Wire.begin(2);                // join i2c bus with address #2
  Wire.onReceive(receiveEvent); // register event
  Serial.begin(9600);           // start serial for output
  pixels.begin(); // This initializes the NeoPixel library.

  //test NeoPixel :
  pixels.setPixelColor(0, pixels.Color(0, 150, 0)); // Moderately bright green color.
  pixels.show(); // This sends the updated pixel color to the hardware.
  //delay(delayval); // Delay for a period of time (in milliseconds).
  Serial.println("Light is on");         // print the integer
  delay(2000);
  pixels.setPixelColor(0, pixels.Color(0, 0, 0)); // off.
  pixels.show(); // This sends the updated pixel color to the hardware.
  //delay(delayval); // Delay for a period of time (in milliseconds).
  Serial.println("Light is off");         // print the integer

}

void loop() {
  delay(100);
}

// function that executes whenever data is received from master
// this function is registered as an event, see setup()
void receiveEvent(int howMany) {
  while (1 < Wire.available()) { // loop through all but the last
    char c = Wire.read(); // receive byte as a character
  }
  int x = Wire.read();    // receive byte as an integer
  if ( x == 1) {
    //givefeedback
    Serial.println("NeoPixelSwitchedOn");
    //turn NeoPixel on :
    pixels.setPixelColor(0, pixels.Color(0, 150, 0)); // Moderately bright green color.
    pixels.show(); // This sends the updated pixel color to the hardware.
    delay(delayval); // Delay for a period of time (in milliseconds).

  } else {
    //givefeedback
    Serial.println("NeoPixelSwitchedOff");
    //turn NeoPixel off :
    pixels.setPixelColor(0, pixels.Color(0, 0, 0)); // off.
    pixels.show(); // This sends the updated pixel color to the hardware.
    delay(delayval); // Delay for a period of time (in milliseconds).
  }
  Serial.println(x);         // print the integer
}




