// defines pins numbers
const int stepPin = 7;  //set variable 'stepPin to pin 7
const int dirPin = 6;   // set variable 'dirPin' to pin 6
int led = 5;  //set variable 'led' to pin 5
 
void setup() {
  // Sets the two pins as Outputs
  pinMode(stepPin,OUTPUT);  //set 'stepPin' as an OUTPUT
  pinMode(dirPin,OUTPUT);   //set dirPin' as an OUTPUT
  pinMode(led, OUTPUT);     //set led as an OUTPUT
  Serial.begin(9600); //Start serial communication with the Serial Monitor at baud rate 9600

  //WARNING - Serial.begin and any Serial.function majorly slows down this code (as the loop is so fast). If you are not getting the speeds you want remove Serial communication.
}
void loop() {
  delay(1000); // One second delay
  digitalWrite(dirPin,HIGH); // Enables the motor to move in a particular direction
// Makes 200 pulses for making one full cycle rotation or 3200 at 1/16 microstep (200*16)
  digitalWrite(led, HIGH); //turn led on to idicate this part of the code
  for(int x = 0; x < 3200; x++) {  // for loop - x will start at 0 and increase by 1 every iteration until the 'x<3200' becomes false at which point the loop will exit
    digitalWrite(stepPin,HIGH); //set stepPin to HIGH - this tells the driver to move the motor one step
    delayMicroseconds(500); //leave enough time for the 'HIGH' to be registered (this can be considerably reduced)
    digitalWrite(stepPin,LOW); //set stepPin to LOW (as the pin must be low for it to become high again)
    delayMicroseconds(500); //delay between steps - reduce this for faster speed.
    Serial.println(x,DEC); //print number of steps
  }
  delay(1000); // One second delay
  digitalWrite(led, LOW);
  //same as above, but the other direction, this time rotating 2 full turns.
  digitalWrite(dirPin,LOW); //Changes the rotations direction
  // Makes 400 pulses for making two full cycle rotation
  for(int x = 0; x < 6400; x++) {
    digitalWrite(stepPin,HIGH);
    delayMicroseconds(500);
    digitalWrite(stepPin,LOW);
    delayMicroseconds(500);
  }
  delay(1000);
}
