#include <Wire.h>
#include <PN532_I2C.h>
#include <PN532.h>
#include <NfcAdapter.h>


#define LED_R_PIN 5 // pin for the RED LED
#define LED_Y_PIN 6 // pin for the YELLOW LED
#define LED_G_PIN 7 // pin for the GREEN LED
#define BTN_Y_PIN 8 // pin for the YES BUTTON
#define BTN_N_PIN 9 // pin for the NO BUTTON

#define ADDR 8 // I2C address

#define Content_Type "text/admin"  // content type of nfc tag
#define USERNAME "myUsername" // username of nfc tag


PN532_I2C pn532_i2c(Wire);
NfcAdapter nfc = NfcAdapter(pn532_i2c);

boolean led = LOW;
boolean p_state = false;

void setup() {
  Serial.begin(115200); // initialize serial communication
  Serial.println("Start...");
  //Wire.begin(); // join i2c bus (address optional for master)
  nfc.begin();                   // initialize the NFC reader

  pinMode(LED_R_PIN, OUTPUT);      // make the led pin an output
  pinMode(LED_Y_PIN, OUTPUT);      // make the led pin an output
  pinMode(LED_G_PIN, OUTPUT);      // make the led pin an output
  pinMode(BTN_Y_PIN, INPUT);      // make the led pin an output
  pinMode(BTN_N_PIN, INPUT);      // make the led pin an output

}

void loop() {
  String text = readTag();
  if (text == USERNAME) {
    Serial.println("lock");
    lock();
  }
}

String readTag() {
  String text = "";

  if (nfc.tagPresent()) {         // if there's a tag present
    NfcTag tag = nfc.read();
    if (tag.hasNdefMessage()) {   // every tag won't have a message
      NdefMessage message = tag.getNdefMessage();
      NdefRecord record = message.getRecord(0);

      if (record.getTnf() == TNF_MIME_MEDIA && record.getType() == Content_Type) {
        // Get the length of the payload:
        int payloadLength = record.getPayloadLength();
        byte payload[payloadLength];  // make a byte array to hold the payload
        record.getPayload(payload);

        // convert the payload to a String
        for (int c = 0; c < payloadLength; c++) {
          if (isprint((char)payload[c])) {
            text += (char)payload[c];
          }
        }
        Serial.println("OK");
      }
    }
  }
  return text;
}

boolean lock() {
  Wire.requestFrom(ADDR, 1);    // request 1 byte from slave device #8
  bool b = true;
  while (Wire.available()) { // slave may send less than requested
    b = Wire.read(); // receive a byte as character
  }
  delay(10);
  Serial.print("Is open?");
  Serial.println(b);
  if (!b) {
    Wire.beginTransmission(ADDR); // transmit to device #8
    Wire.write("opened");        // sends five bytes
    Wire.endTransmission();    // stop transmitting
    delay(10);
    Serial.println("Opened");

    Wire.requestFrom(ADDR, 1);    // request 1 byte from slave device #8
    while (Wire.available()) { // slave may send less than requested
      bool b = Wire.read(); // receive a byte as character
    }
    delay(10);

    Serial.print("Is open?");
    Serial.println(b);
    if (b) {
      Serial.println("Green");
      digitalWrite(LED_G_PIN, HIGH);
      delay(1000);
      digitalWrite(LED_G_PIN, LOW);
      return true;
    }
    else {
      Serial.println("Red");
      digitalWrite(LED_R_PIN, HIGH);
      delay(1000);
      digitalWrite(LED_R_PIN, LOW);
    }
  } else {
    Serial.println("Yellow");
    digitalWrite(LED_Y_PIN, HIGH);
    delay(1000);
    digitalWrite(LED_Y_PIN, LOW);
    Serial.println("Yellow");
  }
  return false;

}

