/**
 * Sketch created from a customized ControlP5 Knob by Andreas Schlegel, 2012 (www.sojamo.de/libraries/controlp5)
 *
 
 edited by laura cipriani, federica selleri and francesco pasino
 fabacademy 2018
 opendot
 *
 */

import processing.serial.*;
import controlP5.*;

ControlP5 cp5;
Serial myPort;  // The serial port

// color int
int myColor = color(155);
float n, n1;


Knob myKnobA; // DCmotor1 (speed)
Knob myKnobB; // DCmotor2 (speed)

Button servoButton; // Servo motor (push ball) 

Slider myStepperA; // Azimuth StepperA (position)
Slider myStepperB; // Elevation StepperB (position)

Textlabel myTextlabelA;
Textlabel myTextlabelB;
Textlabel myTextlabelC;
Textlabel myTextlabelD;
Textlabel myTextlabelE;

////// Setup of DC Motors (A+B), Servo Motor (C), Stepper Motors (D+E) ///////

void setup() {
  size(800, 800);
  smooth();
  noStroke();
  cp5 = new ControlP5(this);
  printArray(Serial.list());
  

  ////// Explaination texts for DC Motors (A+B), Servo Motor (C), Stepper Motors (D+E) ///////

  //DC motor A text
  myTextlabelA = cp5.addTextlabel("labelA")
    .setText("Regulate the speed of the left wheel")
    .setPosition(90, 350)
    .setColor(255)
    //.setFont(createFont("Helvetica",30))
    ;
  //DC motor B text
  myTextlabelB = cp5.addTextlabel("labelB")
    .setText("Regulate the speed of the right wheel")
    .setPosition(300, 350)
    .setColor(255)
    ;
  //Servo motor C text
  myTextlabelC = cp5.addTextlabel("labelC")
    .setText("FIRE!")
    .setPosition(500, 540)
    .setColor(255)
    ;
  //Stepper motor D (azimuth) text    
  myTextlabelD = cp5.addTextlabel("labelD")
    .setText("Regulate the azimuth of the ball shooter")
    .setPosition(95, 60)
    .setColor(255)
    ;
  //Stepper motor E (elevation) text  
  myTextlabelE = cp5.addTextlabel("labelE")
    .setText("Regulate the elevation of the ball shooter")
    .setPosition(500, 60)
    .setColor(255)
    ;


  ////// Sliders and button for DC Motors (A+B), Servo Motor (C), Stepper Motors (D+E) ///////


  //DC motor A
  myKnobA = cp5.addKnob("knobA")
    .setRange(0, 100) //valori ghiera
    .setValue(1)//starting value
    .setPosition(90, 400)
    .setRadius(50)
    .setDragDirection(Knob.VERTICAL)
    ;

  //DC motor B             
  myKnobB = cp5.addKnob("knobB")
    .setRange(0, 100) //valori ghiera
    .setValue(1)//starting value
    .setPosition(300, 400)
    .setRadius(50)
    .setDragDirection(Knob.VERTICAL)
    ;

  // Servo Button
  PImage[] imgs = {loadImage("button_a.png"), loadImage("button_b.png"), loadImage("button_c.png")};
  servoButton = cp5.addButton("play")   
    .setValue(1)//starting value
    .setPosition(500, 450)
    .setImages(imgs)
    .updateSize()
    ;

  // Stepper azimuth
  myStepperA = cp5.addSlider("v1")
    .setPosition(100, 30 ) //posizione barra
    .setSize(200, 20)
    .setRange(0, 120)
    .setValue(60)//starting value
    ;

  // Stepper elevation 
  myStepperB = cp5.addSlider("v2")
    .setPosition(500, 30 )//posizione barra
    .setSize(200, 20)
    .setRange(0, 120)
    .setValue(0)//starting value
    ;


  // Open the port you are using at the rate you want:
  myPort = new Serial(this, Serial.list()[2], 9600);
}


////// Drawing rects to control Stepper Motor ///////


void draw() {
  background(myColor);
  // Drawing bar for controlling stepper azimuth
  pushMatrix();
  translate(150, 200);
  rotate(map(myStepperA.getValue(), 0, 120, -PI/3, PI/3));
  fill(255, 0, 128);
  rect(-50, -50, 100, 120); //centro rotazione 
  popMatrix(); 

  // Drawing bar for controlling stepper elevation
  pushMatrix();
  translate(500, 250);
  rotate(map(myStepperB.getValue(), 0, -120, 0, PI/3));
  fill(255, 0, 128);
  rect(0, -50, 160, 50); //centro rotazione, 
  popMatrix();
}

////// Functions for connection with ARDUINO ///////

// Set speed of DC motorA
void knobA(int theValue) {
  println("A"+theValue);
  myPort.write("A"+theValue+'\n');
}

// Set speed of DC motorA
void knobB(int theValue) {
  println("B"+theValue);
  myPort.write("B"+theValue+'\n');
}

// Turn on/off the servo
void play(int theValue) {
  println("C"+theValue);
  myPort.write("C"+theValue+'\n');
}

// Set azimuth of Stepper A
void v1(int theValue) {
  println("D"+theValue);
  myPort.write("D"+theValue+'\n');
}

// Set elevation of Stepper B
void v2(int theValue) {
  println("E"+theValue);
  myPort.write("E"+theValue+'\n');
}

public void controlEvent(ControlEvent theEvent) {
  println(theEvent.getController().getName());
  n = 0;
}
