#pragma once
#include <Wire.h>
//MPU6050
#define accelScale  100.0/16384.0
#define gyroScale   100.0/16384.0
class MPU6050{
  public:
  const int MPU = 0x68;
  float ax,ay,az,tmp,gx,gy,gz;
  float _1g;
  float Threshold;
  int cnt;
  int toggle;
  MPU6050(){
    Threshold = 10.0;
  }
  ~MPU6050(){

  }
  void init(){
    Wire.begin();      //Wire 라이브러리 초기화
    Wire.beginTransmission(MPU); //MPU로 데이터 전송 시작
    Wire.write(0x6B);  // PWR_MGMT_1 register
    Wire.write(0);     //MPU-6050 시작 모드로
    Wire.endTransmission(true);
  }
  void getData(){
    Wire.beginTransmission(MPU);    //데이터 전송시작
    Wire.write(0x3B);               // register 0x3B (ACCEL_XOUT_H), 큐에 데이터 기록
    Wire.endTransmission(false);    //연결유지
    Wire.requestFrom(MPU,14,true);  //MPU에 데이터 요청
    //데이터 한 바이트 씩 읽어서 반환
    ax=(float)(Wire.read()<<8|Wire.read())*accelScale;  // 0x3B (ACCEL_XOUT_H) & 0x3C (ACCEL_XOUT_L)
    ay=(float)(Wire.read()<<8|Wire.read())*accelScale;  // 0x3D (ACCEL_YOUT_H) & 0x3E (ACCEL_YOUT_L)
    az=(float)(Wire.read()<<8|Wire.read())*accelScale;  // 0x3F (ACCEL_ZOUT_H) & 0x40 (ACCEL_ZOUT_L)
    tmp=(float)(Wire.read()<<8|Wire.read());  // 0x41 (TEMP_OUT_H) & 0x42 (TEMP_OUT_L)
    gx=(float)(Wire.read()<<8|Wire.read())*gyroScale;  // 0x43 (GYRO_XOUT_H) & 0x44 (GYRO_XOUT_L)
    gy=(float)(Wire.read()<<8|Wire.read())*gyroScale;  // 0x45 (GYRO_YOUT_H) & 0x46 (GYRO_YOUT_L)
    gz=(float)(Wire.read()<<8|Wire.read())*gyroScale;  // 0x47 (GYRO_ZOUT_H) & 0x48 (GYRO_ZOUT_L)
    _1g = sqrtf(powf(ax, 2) + powf(ay, 2) + powf(az, 2));//*9.8;
  }
};
