﻿#include <SoftwareSerial.h>
#include <Adafruit_NeoPixel.h>
#include "MPU6050.h"
#include "KalmanFilter.h"
#include "MovingAverageFilter.h"
#define PIN 13
#define NUMPIXELS 4
Adafruit_NeoPixel pixels = Adafruit_NeoPixel(NUMPIXELS, PIN, NEO_GRB + NEO_KHZ800);
SoftwareSerial mySerial(2, 3);//rx:2, tx:3
MPU6050 MPU;
MAFilter MAF;
KFilter KAL;

int CPR() {
	MPU.getData();
	MAF.MovingAverageFilter(MPU._1g);
	KAL.Kalman_Filter(MPU._1g - MAF.Out);

	return (int)KAL.Out;
}
void LED(int _cpr){
	if (_cpr > -1) {
		pixels.setPixelColor(0, pixels.Color(0, 0, 255));
		pixels.setPixelColor(1, pixels.Color(0, 0, 0));
		pixels.setPixelColor(2, pixels.Color(0, 0, 0));
		pixels.setPixelColor(3, pixels.Color(0, 0, 0));
		pixels.show(); // This sends the updated pixel color to the hardware.
	}
	else if (_cpr > -5) {
		pixels.setPixelColor(0, pixels.Color(0, 0, 255));
		pixels.setPixelColor(1, pixels.Color(255, 0, 0));
		pixels.setPixelColor(2, pixels.Color(0, 0, 0));
		pixels.setPixelColor(3, pixels.Color(0, 0, 0));
		pixels.show(); // This sends the updated pixel color to the hardware.
	}
	else if (_cpr > -10) {
		pixels.setPixelColor(0, pixels.Color(0, 0, 255));
		pixels.setPixelColor(1, pixels.Color(255, 0, 0));
		pixels.setPixelColor(2, pixels.Color(255, 0, 0));
		pixels.setPixelColor(3, pixels.Color(0, 0, 0));
		pixels.show(); // This sends the updated pixel color to the hardware.
	}
	else {
		pixels.setPixelColor(0, pixels.Color(0, 0, 255));
		pixels.setPixelColor(1, pixels.Color(255, 0, 0));
		pixels.setPixelColor(2, pixels.Color(255, 0, 0));
		pixels.setPixelColor(3, pixels.Color(0, 255, 0));
		pixels.show(); // This sends the updated pixel color to the hardware.
	}
}

void setup() {
	// put your setup code here, to run once:
	Serial.begin(9600);
	mySerial.begin(9600);
	MPU.init();
	pixels.begin();
}

void loop() {
	// put your main code here, to run repeatedly:
	MPU.getData();
//	Serial.println(MPU._1g);
//	mySerial.println(MPU._1g);

	LED(CPR());
	delay(10);
}