//KalmanFilter
#define ValueQ 1.0/100000.0
#define ValueR 0.1*0.1
class KFilter{
  public:
  float Next;
  float Out;
  float P_next;
  float P;
  float K;
  float Z;
  KFilter(){
  }
  ~KFilter(){
  }

  float Kalman_Filter(float input){
    //예측단계
    Next = Out;    // x_next: 보정 x 예측 x  // x : 추정 된 값
    P_next = P + ValueQ;
    //교정단계
    K = P_next / (P_next + ValueR);  // compute the Kalman gain
    Z = input;         // z: 노이즈낀 원래신호
    Out = Next + K* (Z - Next); // x: 필터링된 신호  // Measurement Update
    P = (1.0 - K) * P_next;

    return Out;
  }
};
