/*
 Main Program by Christopher Nafis
 http://www.seeedstudio.com/depot/grove-dust-sensor-p-1050.html
 http://www.sca-shinyei.com/pdf/PPD42NS.pdf

 Modification Program by SIMP TEAM
 http://www.simpteam.com
 http://www.youtube.com/c/simpteam
*/
 
#include <Wire.h>  //LCD I2C 통신 사용
#include <LiquidCrystal_I2C.h>  //LCD I2C 통신 사용
#include "sound_effect.h"  // 사운드 이펙트 사용(음원효과)

LiquidCrystal_I2C lcd(0x27,16,2);  //LCD 주소 할당 

int blue_pin = 2;  //블루 LED
int green_pin = 3;  //그린 LED
int red_pin = 4;  //레드 LED
int pin = 8;  //먼지센서
int buzzer_pin = 13; //부저
unsigned long duration;   //지속 시간
unsigned long starttime;  //시작 시간
unsigned long sampletime_ms = 5000;   //샘플시간 5초 마다 업데이트
unsigned long lowpulseoccupancy = 0;   //Low 신호가 지속된 시간을 초기화
float ratio = 0;  //비율
float concentration = 0;  //입자 농도 0으로 초기화
float pcsPerCF = 0;  //한 입자당 CF를 0으로 초기화
float ugm3 = 0;  //최종 값으로 세제곱미터 당 마이크로 그램(㎍/㎥)
uint8_t clock[8] = {0x0, 0xe, 0x15, 0x17, 0x11, 0xe, 0x0};  // 시계 이모티콘


void setup() {
  Serial.begin(9600);  //시리얼 통신 시작
  pinMode(8,INPUT);  //미세먼지 센서 입력
  pinMode(2,OUTPUT);  //블루 LED 출력
  pinMode(3,OUTPUT);   //그린 LED 출력
  pinMode(4,OUTPUT);   //레드 LED 출력
  pinMode(13,OUTPUT);   //부저 출력
  digitalWrite(blue_pin, HIGH);   //애노드 RGB LED 이므로 HIGH이면 꺼진다.(이하 2개 동일)
  digitalWrite(green_pin, HIGH); 
  digitalWrite(red_pin, HIGH);  
  starttime = millis();  //현재 시간 대입
  lcd.begin();  //LCD 시작
  lcd.backlight();  //백라이트 ON
  lcd.clear();  //LCD 초기화
  lcd.print("Hello! SIMP!");    //다음 문자를 LDC에 출력
  lcd.setCursor(0, 1);  //두 번째 줄로 커서 이동
  lcd.print("I will find DUST");
  lcd.createChar(1, clock);  //시계 이모티콘 출력
  seSqueak(13);  //초기시작 음원효과
  delay(5000);  // 5초 대기
  if ( ugm3 == 0) {    //만약 결과값이 0보다 작으면 아래를 LCD에 출력한다.
    lcd.clear();
    lcd.print("Analysing Data");
    lcd.write(1);
    lcd.setCursor(0, 1);
    lcd.print("................");        
    lowpulseoccupancy = 0;
    starttime = millis();
  }
}

void loop() {
  duration = pulseIn(pin, LOW); 
  lowpulseoccupancy = lowpulseoccupancy+duration;
  
  if ((millis()-starttime) >= sampletime_ms)  {   //만약 샘플 시간이 5초라면(위에서 정한 샘플 시간)
    ratio = lowpulseoccupancy/(sampletime_ms*10.0);  // 정수 백분율
    concentration = 1.1*pow(ratio,3)-3.8*pow(ratio,2)+520*ratio+0.62; // 미세먼지 센서 사양 시트 곡선 사용
    pcsPerCF = concentration * 100;  // 입자 농도에 100을 곱하면 입자당 CF값
    ugm3 = pcsPerCF / 13000;  //입자당 CF를 13000으로 나누면 미터세제곱당 마이크로그람의 미세먼지 측정값
    
    if (ugm3 > 0.01 ) {   // 만약에 결과값이 0.01보다 크면 미세먼지 값을 출력하라
      lcd.clear();
      lcd.print("Dust:");
      lcd.print(ugm3);
      lcd.print("ug/m3");
      lowpulseoccupancy = 0;
      starttime = millis();
    }
  
    if (ugm3 > 0.01 && ugm3 <= 30) {   //만약 미세먼지 값이 0.01 보다 크고 30이랑 같거나 작으면 아래를 출력
      lcd.setCursor(0, 1);
      lcd.print("Good! ^v^");
      setColor(0, 0, 225);  //블루
      noTone(13);    //소리 끔
    }
    else if (ugm3 > 30 && ugm3 <= 80) {  //만약 미세먼지 값이 30보다 크고 80이랑 같거나 작으면 아래를 출력
      lcd.setCursor(0, 1);
      lcd.print("SoSo! ^ ^;");
      setColor(0, 255, 225);  //블루그린
      noTone(13);   //소리 끔
    }
    else if (ugm3 > 80 && ugm3 <= 150) {  //만약 미세먼지 값이 80보다 크고 150이랑 같거나 작으면 아래를 출력
      lcd.setCursor(0, 1);
      lcd.print("Bad! T.T");
      setColor(255, 120, 0);  //오렌지
      noTone(13);    //소리 끔
    }
    else if (ugm3 > 150) {  //만약 미세먼지 값이 150 보다 크면 아래를 출력
      lcd.setCursor(0, 1);
      lcd.print("Be Careful @.@");
      setColor(255, 0, 0);  //레드
      tone(13, 500);    //500Hz로 소리 재생
    }    
  }
}

void setColor(int red, int green, int blue) {  //RGB LED 출력을 위한 아날로그 출력 세팅
  analogWrite(red_pin, 255-red);
  analogWrite(green_pin, 255-green);
  analogWrite(blue_pin, 255-blue); 
}


