#include <SoftwareSerial.h>
#include <Wire.h>//import necessary libraries: SoftwareSerial, Wire

const byte txPin = PA1;
const byte rxPin = PA0,

SoftwareSerial I2CBT(txpin,rxPin);//define PIN11 and PIN10 as RX and TX

void setup() {
  Serial.begin(9600); //set USB baudrate: 9600
  I2CBT.begin(9600);  
  //BT baudrate: 57600(Warning!! baudrate of each BT module may differ, 
  //please check the data sheet first!!
  pinMode(PA7, OUTPUT); //set pin 13 as output, where we put a LED
}

void loop() {
  byte cmmd[20];
  int insize;
  while(1){
    if ((insize=(I2CBT.available()))>0){ //read BT incoming message
      Serial.print("input size = ");
      Serial.println(insize);
      for (int i=0; i<insize; i++){
        Serial.print(cmmd[i]=char(I2CBT.read()));
        Serial.print(" ");
      }
    }
    switch (cmmd[0]) { //read the first character
    case 97: //97 is 'A' in ASCII CODE
      digitalWrite(PA7,HIGH); //LED light up
      break;

    case 98: //97 is 'B' in ASCII CODE
      Serial.println("Get B");
      digitalWrite(PA7,LOW); //LED off
      break;
    } //Switch
  } //while
}//loop
