  /*
    Analog Input
   Demonstrates analog input by reading an analog sensor on analog pin 0 and
   turning on and off a light emitting diode(LED)  connected to digital pin 13.
   The amount of time the LED will be on and off depends on
   the value obtained by analogRead().
   
   The circuit:
   * Potentiometer attached to analog input 0
   * center pin of the potentiometer to the analog pin
   * one side pin (either one) to ground
   * the other side pin to +5V
   * LED anode (long leg) attached to digital output 13
   * LED cathode (short leg) attached to ground
   
   * Note: because most Arduinos have a built-in LED attached
   to pin 13 on the board, the LED is optional.
   
   
   Created by David Cuartielles
   modified 30 Aug 2011
   By Tom Igoe
   
   This example code is in the public domain.
   
   http://arduino.cc/en/Tutorial/AnalogInput
   
   */
  #include <SoftwareSerial.h>
  #define rxPin 0 // this way is one way to define a value the other is "int sensorPin = 10;"
  #define txPin 1
  
  // set up a new serial port
  SoftwareSerial mySerial =  SoftwareSerial(rxPin, txPin);
  
  int sensorPin = 3;    // select the input pin for the sensor
  int motorPin = 2;      // select the pin for motor
  int sensorValue = 0;  // variable to store the value coming from the sensor
  
  void setup() {
    // declare the motorPin as an OUTPUT:
    pinMode(motorPin, OUTPUT);  
    // declare the motorPin as an OUTPUT:
    pinMode(sensorPin, INPUT);
    mySerial.begin(9600);  
  }
   
    void loop() {
    // read the value from the sensor and report back, if you don't want it to report, add void before loop:
    sensorValue = analogRead(sensorPin);
    mySerial.println(sensorValue);    
    // turn the ledPin on
    digitalWrite(motorPin, HIGH);  
    // stop the program for <sensorValue> milliseconds:
    delay(sensorValue);          
    // turn the ledPin off:        
    digitalWrite(motorPin, LOW);  
    // stop the program for for <sensorValue> milliseconds:
    delay(sensorValue);                  
  }

