/*  NodeMCU, OLED 128x64 I2C
 *  Receives temperature data from the server and shows it on an OLED screen
 *  Server: DTH_server_02.ino
 */ 
#include <SPI.h>
#include <Wire.h>                   // I2C->OLED
#include <LiquidCrystal_I2C.h>
#include <ESP8266WiFi.h>

IPAddress server(192,168,0,80);     // fix IP of the server
WiFiClient client;

//LiquidCrystal_I2C lcd(0x27,16,2);
LiquidCrystal_I2C lcd(0x27, 2, 1, 0, 4, 5, 6, 7, 3, POSITIVE);

char ssid[] = "Massei_2.4Ghz";
char pass[] = "ALDOROSSI88";
byte xc = 1, yc = 23, dx = 1, dy = 1;
unsigned long askTimer = 0;
unsigned long oledTimer = 0;
String answer;
//uint8_t pinD1 = 5;    // I2C Bus SCL (clock)
//uint8_t pinD2 = 4;    // I2C Bus SDA (data)
//uint8_t pinD3 = 0;
//uint8_t pinD4 = 2;


void setup() {
  lcd.begin(16,2);
  Serial.begin(115200);

  WiFi.begin(ssid, pass);
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
  }
}

void loop () {
  if (millis() - askTimer > 2340) {         // time between two connection to the server
    client.connect(server, 80);             // connects to the server
    client.println("Haliho szerver!\r");    // trigger message to the server, its value is scrapped
    answer = client.readStringUntil('\r');  // received the server's answer
    Serial.println(answer);  

    lcd.clear();
    lcd.setCursor(0,0);
    lcd.print("Temperature C");    
    lcd.setCursor(0,1);
    lcd.print(answer);
    delay(2000);
//    lcd.clear;
//    lcd.setCursor(0,0);
//    lcd.print("Humidity %");    
//    lcd.setCursor(0,1);
//    lcd.print(answer);
            

    client.flush();
    askTimer = millis();

  }
}
