/* Wemos D1 mini, OLED 128x64 I2C, DHT22
 * Sends the temperature value to the client(s)
 * v2: server restart after 30 sec idle time
 */
#include "DHT.h"                    // DHT22
#include <SPI.h>                    // SD
#include <Wire.h>                   // I2C->LCD
#include <ESP8266WiFi.h>

#define DHTPIN 5                   // DHT pin (D7=13)
#define DHTTYPE DHT22

WiFiServer server(80);              // launches the server
IPAddress ip(192, 168, 0, 80);      // fix IP of the server
IPAddress gateway(192,168,0,1);     // WiFi router's IP
IPAddress subnet(255,255,255,0);
DHT dht(DHTPIN, DHTTYPE);

char ssid[] = "Massei_2.4Ghz";
char pass[] = "ALDOROSSI88";
byte xc = 1, yc = 23, dx = 1, dy = 1;
unsigned long DHTtimer = 0;
float h, t;
unsigned long clientTimer = 0;

void setup() {
  Serial.begin(115200);                     // only for debug
  dht.begin();
  Wire.begin();                               // default SDA and SCL
  server_start(0);                            // starts the WiFi server
  delay(2000);
}

void loop() {
  if (millis() > DHTtimer + 2000) {
    h = dht.readHumidity();
    t = dht.readTemperature();   
    Serial.println(t);
    Serial.println(h);// reads the DHT for temperature
    if (isnan(h) || isnan(t)) {
      return;
    } else {
      DHTtimer = millis();
    }

  }
  WiFiClient client = server.available();
  if (client) {
    if (client.connected()) {
      String request = client.readStringUntil('\r');    // reads the message from the client
      client.flush();
      client.println(String(t, 1));  

    }
    client.stop();                         // disconnects the client
    clientTimer = millis();
  }
  if (millis() - clientTimer > 30000) {    // stops and restarts the WiFi server after 30 sec
    WiFi.disconnect();                     // idle time
    delay(500);
    server_start(1);
  }
}

void server_start(byte restart) {
  if (restart) {
  
  }
  WiFi.config(ip, gateway, subnet);
  WiFi.begin(ssid, pass);
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
  }
  server.begin();
  delay(500);
  clientTimer = millis();
}
