#include <ESP8266WiFi.h>
#include <ArduinoJson.h>

#include <Adafruit_NeoPixel.h>

#include <DNSServer.h>
#include <ESP8266WebServer.h>
#include <WiFiManager.h>  

#include "index.h" //HTML webpage contents

ESP8266WebServer server(80); //Server on port 80
WiFiClient client;

#define LED_PIN   14
#define LED_COUNT 160

#define ARDUINOJSON_DEFAULT_NESTING_LIMIT 30


String CityID;
String APIKEY = "YOUR API KEY";                                 

char servername[]="api.openweathermap.org";       
int  counter = 60;                                      

String weatherLocation = "";
String weatherMain = "";
String realweather;
const int relay1 = 5;
const int relay2 = 4 ;


//// LED strings
class Strip
{
public:
  uint8_t   effect;
  uint8_t   effects;
  uint16_t  effStep;
  unsigned long effStart;
  Adafruit_NeoPixel strip;
  Strip(uint16_t leds, uint8_t pin, uint8_t toteffects) : strip(leds, pin, NEO_GRB + NEO_KHZ800) {
    effect = -1;
    effects = toteffects;
    Reset();
  }
  void Reset(){
    effStep = 0;
    effect = (effect + 1) % effects;
    effStart = millis();
  }
};

struct Loop
{
  uint8_t currentChild;
  uint8_t childs;
  bool timeBased;
  uint16_t cycles;
  uint16_t currentTime;
  Loop(uint8_t totchilds, bool timebased, uint16_t tottime) {currentTime=0;currentChild=0;childs=totchilds;timeBased=timebased;cycles=tottime;}
};

Strip strip_0(160, 14, 160 );
struct Loop strip0loop0(1, false, 1);
struct Loop strip0loop00(2, false, 20);
struct Loop strip0loop000(1, false, 5);

////



void setup() {
  
  Serial.begin(115200);

  strip_0.strip.begin();          
  strip_0.strip.setBrightness(220); 

  pinMode(relay1, OUTPUT);
  pinMode(relay2, OUTPUT);

  digitalWrite(relay1, LOW);
  digitalWrite(relay2, LOW);
 
  Serial.println("Connecting");

  WiFiManager wifiManager;
  wifiManager.autoConnect("Weather Report AP");
  
  Serial.println("Connected");
  server.on("/", handleRoot);      //Which routine to handle at root location
  server.on("/action_page", handleForm);
  server.begin();                  //Start server
  Serial.println("HTTP server started");
  strip_0.strip.show();
  delay(2000);
    
}


void loop() {
    String CityID;
    interrupts();
    server.handleClient(); 
    climateConditions();
    

}




void getWeatherData(String CityName)                                //client function to send/receive GET request data.
{
String result;

interrupts();
 
  if (client.connect(servername, 80))   
          {                                         //starts client connection, checks for connection
          client.println("GET /data/2.5/weather?q="+CityName+"&units=metric&APPID="+APIKEY);
          client.println("Host: api.openweathermap.org");
          client.println("User-Agent: ArduinoWiFi/1.1");
          client.println("Connection: close");
          client.println();
          } 
  else {
         Serial.println("connection failed");        //error message if no client connect
          Serial.println();
       }

  while(client.connected() && !client.available()) 
  delay(1000);                                          //waits for data
  while (client.connected() || client.available())    
       {                                             //connected or data available
         char c = client.read();                     //gets byte from ethernet buffer
         result = result+c;
         
       }

result.replace('[', ' ');
result.replace(']', ' ');
result.replace('ç', 'c');
result.replace('ã', 'a');


char jsonArray [result.length()+1];
result.toCharArray(jsonArray,sizeof(jsonArray));
jsonArray[result.length()+1] = '\0';
StaticJsonBuffer<1600> json_buf;
JsonObject &root = json_buf.parseObject(jsonArray);

String location = root["name"];
String weather = root["weather"]["main"];
weatherLocation = location;

CityName.replace('ç', 'c');
CityName.replace('ã', 'a');

CityID.replace('ç', 'c');
CityID.replace('ã', 'a');

delay(200);
Serial.println(weather);
realweather=weather;
Serial.println(realweather);

if (!root.success())
  {
    colorWipe(0,0);
    Serial.println("parseObject() failed");
  }

delay(1000); 
client.flush();//stop client
client.stop();  

}

void climateConditions() { 
  

if (realweather =="Clear") 
          {  
            strips_loop();    
            //rain02();    
          }
          
if (realweather =="Clouds") 
          { 
            strips_loop2();
            
          }


if (realweather =="Drizzle") 
          {  
            
           rain01();
                 
          }

if (realweather =="Rain") 
          {  
            
          rain02();  
//          strips_loop3();
                 
          }


if (realweather =="Thunderstorm") 
          {  
            
           rain03();  
                 
          }          

if (realweather == "Mist")
          {
           mist100();  
          }


}



//===============================================================
// This routine is executed when you open its IP in browser
//===============================================================
void handleRoot() {
 String s = MAIN_page; //Read HTML contents
 server.send(200, "text/html", s); //Send web page
}

//===============================================================
// This routine is executed when you press submit
//===============================================================
void handleForm() 
{
 
CityID = server.arg("city"); 
CityID.replace('ç', 'c');
CityID.replace('ã', 'a');
 
  Serial.print("Weather Report for ");
  Serial.println(CityID);
 
  getWeatherData(CityID);
  delay(300);
 
  String s = MAIN_page;
  server.send(200, "text/html", s); //Send web page
  server.sendHeader("Location", "/");
}

void mist100() {
    
    digitalWrite(relay2, HIGH);
    delay(8000);
    digitalWrite(relay2, LOW);
    delay(1000);
    strip_0.strip.show();
  
}

// Relay routines
void rain01() {
    
    digitalWrite(relay1, HIGH);
    delay(2000);
    digitalWrite(relay1, LOW);
    delay(2000);
    strip_0.strip.show();
  
}

void rain02() {
          delay(10);
          //colorWipe(strip_0.strip.Color(255,   255,   0), 1);
          theaterChase(strip_0.strip.Color(255, 127, 0), 40);
          colorWipe(0,0);
          delay(100);
          digitalWrite(relay1, HIGH);
          theaterChase(strip_0.strip.Color(255, 127, 0), 80);
          delay(8000);
          digitalWrite(relay1, LOW);

          delay(500);
          
          
 
}


void rain03() {
          delay(10);
          //colorWipe(strip_0.strip.Color(255,   255,   0), 1);
          theaterChase(strip_0.strip.Color(255, 127, 0), 40);
          colorWipe(0,0);
          delay(100);
          digitalWrite(relay1, HIGH);
          theaterChase(strip_0.strip.Color(255, 127, 0), 80);
          delay(5000);
          digitalWrite(relay1, LOW);
          theaterChase(strip_0.strip.Color(255, 127, 0), 120);

          delay(500);
          
}


void theaterChase(uint32_t color, int wait) {
  for(int a=0; a<10; a++) {  // Repeat 10 times...
    for(int b=0; b<3; b++) { //  'b' counts from 0 to 2...
      strip_0.strip.clear();         //   Set all pixels in RAM to 0 (off)
      // 'c' counts up from 'b' to end of strip in steps of 3...
      for(int c=b; c<strip_0.strip.numPixels(); c += 3) {
        strip_0.strip.setPixelColor(c, color); // Set pixel 'c' to value 'color'
      }
      strip_0.strip.show(); // Update strip with new contents
      delay(wait);  // Pause for a moment
    }
  }
}


void colorWipe(uint32_t color, int wait) {
  for(int i=0; i<strip_0.strip.numPixels(); i++) { // For each pixel in strip...
    strip_0.strip.setPixelColor(i, color);         //  Set pixel's color (in RAM)
    strip_0.strip.show();                          //  Update strip to match
    delay(wait);                           //  Pause for a moment
  }
}



// LED Routines
void strips_loop() {
  if(strip0_loop0_eff0() & 0x01) {
    strip_0.strip.show();
}
}

void strips_loop2() {

  if(strip0_loop00_eff0() & 0x01) {
    strip_0.strip.show();
}
}

void strips_loop3() {

    if(strip0_loop000_eff0() & 0x01) {
    strip_0.strip.show();
}
}






uint8_t strip0_loop0() {
  uint8_t ret = 0x00;
  switch(strip0loop0.currentChild) {
    case 0: 
           ret = strip0_loop0_eff0();break;
  }
  if(ret & 0x02) {
    ret &= 0xfd;
    if(strip0loop0.currentChild + 1 >= strip0loop0.childs) {
      strip0loop0.currentChild = 0;
      if(++strip0loop0.currentTime >= strip0loop0.cycles) {strip0loop0.currentTime = 0; ret |= 0x02;}
    }
    else {
      strip0loop0.currentChild++;
    }
  };
  return ret;
}

uint8_t strip0_loop0_eff0() {
    // Strip ID: 0 - Effect: Rainbow - LEDS: 80
    // Steps: 46 - Delay: 5
    // Colors: 3 (255.255.0, 255.133.0, 203.144.0, )
    // Options: toLeft=true, 
  if(millis() - strip_0.effStart < 45 * (strip_0.effStep)) return 0x00;
  float factor1, factor2;
  uint16_t ind;
  for(uint16_t j=0;j<150;j++) {
    ind = strip_0.effStep + j * 0.92;
    switch((int)((ind % 46) / 15.333333333333334)) {
      case 0: factor1 = 1.0 - ((float)(ind % 46 - 0 * 15.333333333333334) / 15.333333333333334);
              factor2 = (float)((int)(ind - 0) % 46) / 15.333333333333334;
              strip_0.strip.setPixelColor(j, 255 * factor1 + 190 * factor2, 117 * factor1 + 117 * factor2, 0 * factor1 + 0 * factor2);
              break;
      case 1: factor1 = 1.0 - ((float)(ind % 46 - 1 * 15.333333333333334) / 15.333333333333334);
              factor2 = (float)((int)(ind - 15.333333333333334) % 46) / 15.333333333333334;
              strip_0.strip.setPixelColor(j, 255 * factor1 + 203 * factor2, 133 * factor1 + 144 * factor2, 0 * factor1 + 0 * factor2);
              break;
      case 2: factor1 = 1.0 - ((float)(ind % 46 - 2 * 15.333333333333334) / 15.333333333333334);
              factor2 = (float)((int)(ind - 30.666666666666668) % 46) / 15.333333333333334;
              strip_0.strip.setPixelColor(j, 203 * factor1 + 255 * factor2, 144 * factor1 + 255 * factor2, 0 * factor1 + 0 * factor2);
              break;
    }
  }
  if(strip_0.effStep >= 46) {strip_0.Reset(); return 0x03; }
  else strip_0.effStep++;
  return 0x01;
}

uint8_t strip0_loop00() {
  uint8_t ret = 0x00;
  switch(strip0loop00.currentChild) {
    case 0: 
           ret = strip0_loop00_eff0();break;
    case 1: 
           ret = strip0_loop000();break;
  }
  if(ret & 0x02) {
    ret &= 0xfd;
    if(strip0loop00.currentChild + 1 >= strip0loop00.childs) {
      strip0loop00.currentChild = 0;
      if(++strip0loop00.currentTime >= strip0loop00.cycles) {strip0loop00.currentTime = 0; ret |= 0x02;}
    }
    else {
      strip0loop00.currentChild++;
    }
  };
  return ret;
}

uint8_t strip0_loop00_eff0() {
    // Strip ID: 0 - Effect: Rainbow - LEDS: 80
    // Steps: 80 - Delay: 20
    // Colors: 3 (0.192.255, 0.79.193, 0.0.255, )
    // Options: toLeft=true, 
  if(millis() - strip_0.effStart < 20 * (strip_0.effStep)) return 0x00;
  float factor1, factor2;
  uint16_t ind;
  for(uint16_t j=0;j<150;j++) {
    ind = strip_0.effStep + j * 1;
    switch((int)((ind % 80) / 26.666666666666668)) {
      case 0: factor1 = 1.0 - ((float)(ind % 80 - 0 * 26.666666666666668) / 26.666666666666668);
              factor2 = (float)((int)(ind - 0) % 80) / 26.666666666666668;
              strip_0.strip.setPixelColor(j, 0 * factor1 + 0 * factor2, 192 * factor1 + 79 * factor2, 255 * factor1 + 193 * factor2);
              break;
      case 1: factor1 = 1.0 - ((float)(ind % 80 - 1 * 26.666666666666668) / 26.666666666666668);
              factor2 = (float)((int)(ind - 26.666666666666668) % 80) / 26.666666666666668;
              strip_0.strip.setPixelColor(j, 0 * factor1 + 0 * factor2, 79 * factor1 + 0 * factor2, 193 * factor1 + 255 * factor2);
              break;
      case 2: factor1 = 1.0 - ((float)(ind % 80 - 2 * 26.666666666666668) / 26.666666666666668);
              factor2 = (float)((int)(ind - 53.333333333333336) % 80) / 26.666666666666668;
              strip_0.strip.setPixelColor(j, 0 * factor1 + 0 * factor2, 0 * factor1 + 192 * factor2, 255 * factor1 + 255 * factor2);
              break;
    }
  }
  if(strip_0.effStep >= 80) {strip_0.Reset(); return 0x03; }
  else strip_0.effStep++;
  return 0x01;
}

uint8_t strip0_loop000() {
  uint8_t ret = 0x00;
  switch(strip0loop000.currentChild) {
    case 0: 
           ret = strip0_loop000_eff0();break;
  }
  if(ret & 0x02) {
    ret &= 0xfd;
    if(strip0loop000.currentChild + 1 >= strip0loop000.childs) {
      strip0loop000.currentChild = 0;
      if(++strip0loop000.currentTime >= strip0loop000.cycles) {strip0loop000.currentTime = 0; ret |= 0x02;}
    }
    else {
      strip0loop000.currentChild++;
    }
  };
  return ret;
}

uint8_t strip0_loop000_eff0() {
    // Strip ID: 0 - Effect: Blink - LEDS: 80
    // Steps: 40.2 - Delay: 5
    // Colors: 2 (0.0.0, 255.255.0, )
    // Options: timeBegin=50, timeToOn=10, timeOn=31, timeToOff=10, timeOver=100, every=4, 
  if(millis() - strip_0.effStart < 5 * (strip_0.effStep)) return 0x00;
  uint8_t e,r,g,b;
  if(strip_0.effStep < 10) {
    for(uint16_t j=0;j<150;j++) 
      strip_0.strip.setPixelColor(j, 0, 0, 0);
  }
  else if(strip_0.effStep  < 12) {
    e = (strip_0.effStep * 5) - 50;
    r = 255 * ( e / 10 ) + 0 * ( 1.0 - e / 10 );
    g = 255 * ( e / 10 ) + 0 * ( 1.0 - e / 10 );
    b = 0 * ( e / 10 ) + 0 * ( 1.0 - e / 10 );
    for(uint16_t j=0;j<150;j++) 
      if((j%4)==0) strip_0.strip.setPixelColor(j, r, g, b);
      else strip_0.strip.setPixelColor(j, 0, 0, 0);
  }
  else if(strip_0.effStep < 18.2) {
    for(uint16_t j=0;j<150;j++) 
      if((j%4)==0) strip_0.strip.setPixelColor(j, 255, 255, 0);
      
      else strip_0.strip.setPixelColor(j, 0, 0, 0);
  }
  else if(strip_0.effStep < 20.2) {
    e = (strip_0.effStep * 5) - 91;
    r = 0 * ( e / 10 ) + 255 * ( 1.0 - e / 10 );
    g = 0 * ( e / 10 ) + 255 * ( 1.0 - e / 10 );
    b = 0 * ( e / 10 ) + 0 * ( 1.0 - e / 10 );
    for(uint16_t j=0;j<150;j++) 
      if((j%4)==0) strip_0.strip.setPixelColor(j, r, g, b);
      else strip_0.strip.setPixelColor(j, 0, 0, 0);
  }
  else {
    for(uint16_t j=0;j<150;j++) 
      strip_0.strip.setPixelColor(j, 0, 0, 0);
  }
  if(strip_0.effStep >= 40.2) {strip_0.Reset(); return 0x03; }
  else strip_0.effStep++;
  return 0x01;
}
