#include "SdsDustSensor.h"

//Variable that will never change
const int rxPin = 10; // txSensorPin
const int txPin = 9; // rxSensorPin
const int numReadings = 5; //numReadings is the number of data that it will be taken to creat a average data (smoothing the data)
const float thresholdVariation = 5;
const int led1 = 2;
const int led2 = 3;
const int led3 = 4;
const int p25 = 0;
const int p10 = 1;
const int numChannel = 2;

//Variable that will change during time
bool firstTime[numChannel]; //Condition of running a part of the code
float lastTriggerVal[numChannel]; //stores the last value that moved by more than thresholdVariation
float readings[numChannel][numReadings];
//1st float =input reading  new float = will become output variable
float runningAverage[numChannel];
float total[numChannel];
int readingIndex = 0;
SdsDustSensor sds(rxPin, txPin);


void setup() {
  Serial.begin(9600); //Speed of communication BAUD (in the sdsLibrary the Baud was at 9600)
  sds.begin(); //sensor be prepare to work

  pinMode(led1, OUTPUT);
  pinMode(led2, OUTPUT);
  pinMode(led3, OUTPUT);

  Serial.println(sds.queryFirmwareVersion().toString()); // prints firmware version
  delay(50);
  Serial.println(sds.setActiveReportingMode().toString()); // ensures sensor is in 'active' reporting mode
  delay(50);
  Serial.println(sds.setContinuousWorkingPeriod().toString()); // sensor sends data every 3 minutes
  delay(50);

  for (int channel = 0; channel < numChannel; channel++) {
    lastTriggerVal[channel] = 0;
    runningAverage[channel] = 0;
    total[channel] = 0;
    firstTime[channel] = true;
    for (int reading = 0; reading <= numReadings; reading++) {
      readings[channel][reading] = 0;
    }
  }
}

void loop() {
  //read data
  PmResult pm = sds.readPm();

  if (pm.isOk()) {    
    for (int channel = 0 ; channel < numChannel ; channel++) {
      // subtract oldest reading
      total[channel] = total[channel] - readings[channel][readingIndex];
      
      if (channel == 0) {
        Serial.println("---CHANNEL 25 ---");
        readings[channel][readingIndex] = pm.pm25; //readingIndex = l'offset de l'index (0-1-2-3-4-5)
      } else if (channel == 1) {
        Serial.println("--- CHANNEL 10 ---");
        readings[channel][readingIndex] = pm.pm10;
      }

      //  Serial.print("PM2.5 = ");
      //  Serial.print(readings[channel][readingIndex]);
      //  Serial.print(", PM10 = ");
      //  Serial.println(readings10[readingIndex]);

      //update totals
      total[channel] += readings[channel][readingIndex];

      //update average
      runningAverage[channel] = total[channel] / numReadings;
      Serial.println(runningAverage[channel]);
      delay(50);

      if (channel == 0) {
        if ((runningAverage[channel] >= 0) && (runningAverage[channel] <= 12)) {
          Serial.println(" -Good air- ");
        } else if ((runningAverage[channel] >= 13) && (runningAverage[channel] <= 35)) {
          Serial.println(" -Moderate air- ");
        } else if ((runningAverage[channel] >= 36) && (runningAverage[channel] <= 55)) {
          Serial.println(" -Unhealthy for sensitive groupe- ");
        } else if ((runningAverage[channel] >= 56) && (runningAverage[channel] <= 150)) {
          Serial.println(" -Unhealty- ");
        } else if ((runningAverage[channel] >= 151) && (runningAverage[channel] <= 250)) {
          Serial.println(" -Very unhealty- ");
        } else {
          Serial.println(" -You will die soon- ");
        }
      } else if (channel == 1) {
        if ((runningAverage[channel] >= 0) && (runningAverage[channel] <= 54)) {
          Serial.println(" -Good air- ");
        } else if ((runningAverage[channel] >= 55) && (runningAverage[channel] <= 154)) {
          Serial.println(" -Moderate air- ");
        } else if ((runningAverage[channel] >= 155) && (runningAverage[channel] <= 254)) {
          Serial.println(" -Unhealthy for sensitive groupe- ");
        } else if ((runningAverage[channel] >= 255) && (runningAverage[channel] <= 354)) {
          Serial.println(" -Unhealty- ");
        } else if ((runningAverage[channel] >= 355) && (runningAverage[channel] <= 424)) {
          Serial.println(" -Very unhealty- ");
        } else {
          Serial.println(" -You will die soon- ");
        }
      }
      delay(50);

      //TRIGGERS
      // firtTime = true. we ask if firstTime = false. it's not == to false so we skip the next part(== EST-CE QUE)
      if (!firstTime[channel]) {
        if (runningAverage[channel] - lastTriggerVal[channel] >= thresholdVariation) {
          Serial.println("-Increasing -");
          delay(50);
          lastTriggerVal[channel] = runningAverage[channel];
        } else if (runningAverage[channel] - lastTriggerVal[channel] <= thresholdVariation) {
          Serial.println("-Decreasing -");
          delay(50);
          lastTriggerVal[channel] = runningAverage[channel];
        } else {
          Serial.println("-Stable -");
          delay(50);
        }
      } else {
        firstTime[channel] = false;  // next time firstTime will not equal to true but false so it will read this previous section
        lastTriggerVal[channel] = runningAverage[channel];
      }
    }
    
    //update index
    readingIndex++;
    if (readingIndex >= numReadings) {
      readingIndex = 0;
    }
  } else {
    Serial.println("Could not read values from sensor, reason: ");
    delay(50);
    Serial.println(pm.statusToString());
    delay(50);
  }
  delay(1000);
}
