
// libraries included
#include <Wire.h>
#include <NewPing.h>

//decleares two digital Pins as Trig and Echo
#define trig 3
#define echo 4
#define max_distance 8
#define trigPin 9
#define echoPin 10
#define buttonPin 2

// NewPing setup of pins and maximum distance
NewPing sonar(trig, echo, max_distance); 

// defines variables
long duration;
int distance;
int spacing;
boolean flag = true;
int buttonState = 0; 
int red_score = 0;
int blue_score = 0;


void setup() {
pinMode(trigPin, OUTPUT); // Sets the trigPin as an Output
pinMode(echoPin, INPUT); // Sets the echoPin as an Input
pinMode(buttonPin, INPUT_PULLUP);
Serial.begin(4800);
}

void loop() {
  //reads the Buttonstate 0 = LOW 1 = HIGH
  buttonState = digitalRead(buttonPin);
  // prints the Buttonstate, I only use it to check if the Button works
  Sonar();
  Sonar_using_Lib();
  // if the Button gets pressed, change the value of the flag and start the game 
  if (buttonState == LOW){
    flag = true;
  }
}

void Sonar () {
  // Clears the trigPin
digitalWrite(trigPin, LOW);
delayMicroseconds(2);
// Sets the trigPin on HIGH state for 10 micro seconds
digitalWrite(trigPin, HIGH);
delayMicroseconds(10);
digitalWrite(trigPin, LOW);
// Reads the echoPin, returns the sound wave travel time in microseconds
duration = pulseIn(echoPin, HIGH);
// Calculating the distance
distance= duration*0.034/2;

// Prints the distance on the Serial Monitor only if the flag is true 
if (flag == true ) {
Serial.print("Distance of Team Red: ");
Serial.print(distance);
Serial.println("cm");
// If the value is between 0 - 8 a Goal has been made
if (distance <9 && distance >0) {
  //counts the score
  red_score = red_score +1;
  Serial.println(" GOAL !!! FOR TEAM RED");
  Serial.println("Score: Team Blue | Team Red");
  Serial.print(blue_score); 
  Serial.print(" | ");
  Serial.println(red_score);
  delay(100);
  // stops the output on the serial to reset it (to restart the game) push the button
  flag = false;
    }
  }
}

void Sonar_using_Lib() {
delay(50);
spacing = sonar.ping_cm();
// Prints the distance on the Serial Monitor only if the flag is true 
if (flag == true) {
Serial.print("Distance of Team Blue: " );
Serial.print(spacing);
Serial.println("cm");
// If the value is between 0 - 8 a Goal has been made
if (spacing <9 && spacing > 0) {
  //counts the score
  blue_score = blue_score +1;
  Serial.println(" GOAL !!! FOR TEAM BLUE");
  Serial.println("Score: Team Blue | Team Red");
  Serial.print(blue_score); 
  Serial.print(" | ");
  Serial.println(red_score);
  delay(100);
  // stops the output on the serial to reset it (to restart the game) push the button
  flag = false;
    }
  }
}
