// include Serial and GUI Library 
import controlP5.*;
import processing.serial.*;
 
// Create object for monitoring a serial port
Serial myPort;

ControlP5 cp5; //create ControlP5 object
PFont font; 

String score_blue;      // Data received from the serial port
String score_red;       // Data received from the serial port

 
// setup() is executed once at the beginning of the program
void setup() {
  size(500, 300); //window size, (width, height)
  // initialize myPort, set transfer rate as for Arduino Sketch
  myPort = new Serial(this, "/dev/cu.usbmodem14101", 9600);
  
  cp5 = new ControlP5(this);
  font = createFont("arial", 30); // custom fonts for buttons and title
  
  cp5.addButton("TeamBlue")     //"TeamBed" is the name of the left button
    .setPosition(70, 100)  //x and y coordinates of upper left corner of button
    .setSize(180, 70)      //(width, height)
    .setFont(font)
  ;   

  cp5.addButton("TeamRed")     //"TeamRed" is the name of the right button
    .setPosition(270, 100)  //x and y coordinates of upper left corner of button
    .setSize(180, 70)      //(width, height)
    .setFont(font)
  ;

}
 
// Like loop() with Arduino, draw() is called again and again as long as the program is executed.
void draw() {
  background(150, 50 , 150); // background color of window (r, g, b) or (0 to 255)
  //lets give title to our window
  fill(0, 0, 0);     //text color (r, g, b)
  textFont(font);
  text("SCORE", 200, 50);  // ("text", x coordinate, y coordinat)
  if (myPort.available() > 0) {  // If data is available,
  score_blue = myPort.readString();         // read it and store it in score_blue
  score_red = myPort.readString();         // read it and store it in score_red
  } 
  println(score_blue); //print it out in the console
  println(score_red); //print it out in the console
  delay(100);
  
  String blue = score_blue;
  String red = score_red;
  
  if (score_blue != null) {
  text(blue, 160, 200);  // ("text", x coordinate, y coordinat)
  }
  if (score_red != null) {
  text(red, 160, 200);  // ("text", x coordinate, y coordinat)
  }
}

//lets add some functions to our buttons
//so whe you press any button, it sends perticular char over serial port

  void TeamBlue(){
  myPort.write('1');
}
 void TeamRed(){
  myPort.write('1');
}



 
