#include <math.h>
#include "U8glib.h"

// for Write Programm
#define MOSI 11
#define MISO 12
#define SCK 13
#define RESET 22

// for Serial Communication
#define RXD 0
#define TXD 1

// OUTPUT PINS 5,6
#define PWM_PIN_1 5 
#define PWM_PIN_2 6
// LED PINS 0～4
#define LED_1 2
#define LED_2 3
#define LED_3 4

// INPUT PINS
// TERMO_SENSOR PIN 15 A1
#define THERMO_SENSOR A1
// POTENTIOMETOR PIN 14 A0
#define TEMPERATURE_SETTING A0
//  PWM OUTPUT VALUE
#define PWM_VALUE 255

// Temperature Setting Value
#define COOL 1
#define NORMAL 2
#define WARM 3

// OLED SH1106 Driver setting
U8GLIB_SH1106_128X64 u8g(13, 11, 10, 12);  // SW SPI Com: SCK = 13, MOSI = 11, CS = 10, A0 = 12

float temperature = 0.0;
int setting = NORMAL;
String strSetting = "NORMAL";

// OLED Display draw 
void draw(void) {
  // graphic commands to redraw the complete screen should be placed here  
  u8g.setFont(u8g_font_unifont);
  //u8g.setFont(u8g_font_osb21);
  byte strLen = u8g.drawStr( 0, 22, "NowTemp:");
  u8g.setPrintPos(strLen + 5, 22);
  u8g.print(temperature);
  strLen = u8g.drawStr( 0, 44, "Setting:");  
  u8g.setPrintPos(strLen + 5, 44);
  u8g.print(strSetting);  
}

// initialize
void setup() {
  //  Serial.begin(9600); // for Debug
  analogReference(DEFAULT); // AnalogRead range of 0～5V 
  pinMode(PWM_PIN_1, OUTPUT);
  pinMode(PWM_PIN_2, OUTPUT);
  pinMode(LED_1, OUTPUT);
  pinMode(LED_2, OUTPUT);
  pinMode(LED_3, OUTPUT);
  
  pinMode(THERMO_SENSOR, INPUT);
  pinMode(TEMPERATURE_SETTING, INPUT);
  
  resetLED();
  
  // flip screen, if required
//  u8g.setRot180();
  
  // set SPI backup if required
  //u8g.setHardwareBackup(u8g_backup_avr_spi);

  // assign default color value
  if ( u8g.getMode() == U8G_MODE_R3G3B2 ) {
    u8g.setColorIndex(255);     // white
  }
  else if ( u8g.getMode() == U8G_MODE_GRAY2BIT ) {
    u8g.setColorIndex(3);         // max intensity
  }
  else if ( u8g.getMode() == U8G_MODE_BW ) {
    u8g.setColorIndex(1);         // pixel on
  }
  else if ( u8g.getMode() == U8G_MODE_HICOLOR ) {
    u8g.setHiColorByRGB(255,255,255);
  }
  
  pinMode(8, OUTPUT);
}

void loop() { 
  // GetTemperatureSetting
  setting = getTemperatureSetting();
  // GetTemperatureValue
  temperature = getTemperature();
  // Output PWM
  outputPWM();
  // 1000ms wait
  delay(1000);
  // picture loop
  u8g.firstPage();  
  do {
    draw();
  } while( u8g.nextPage() );  
}

/**
 * get Temperature
 * return setting 
 */
int getTemperatureSetting(){
//  Serial.println("getTemperatureSetting Start");
  int ret = NORMAL;
  // analogRead 0～1023
  int val = analogRead(TEMPERATURE_SETTING);
  if(val < 350){
    digitalWrite(LED_1, LOW);
    digitalWrite(LED_2, LOW);
    digitalWrite(LED_3, HIGH);
    ret = WARM;    
    strSetting = "WARM";
  }else if(val > 700){ 
    digitalWrite(LED_1, HIGH);
    digitalWrite(LED_2, LOW);
    digitalWrite(LED_3, LOW);
    ret = COOL;    
    strSetting = "COOL";
  }else{
    digitalWrite(LED_1, LOW);
    digitalWrite(LED_2, HIGH);
    digitalWrite(LED_3, LOW);
    ret = NORMAL;      
    strSetting = "NORMAL";
  }
//  Serial.println(ret);
//  Serial.println("getTemperatureSetting End");
  return ret;
}

/**
 * read Temperature Value
 * return temperature 0～50
 */
float getTemperature(){
  Serial.println("getTemperature Start");
  // Read analog Value
  int val = analogRead(THERMO_SENSOR);
  float temp = val * (506.0 / 1023.0);
  temp = floor(temp * 100) /100; 
  Serial.println(temp);  
  Serial.println("getTemperature End");
  return (float)temp;
}

/**
 * Turn off All LED
 */
void resetLED(){  
  digitalWrite(LED_1, LOW);
  digitalWrite(LED_2, LOW);
  digitalWrite(LED_3, LOW);
}

/**
 * PWM OUTPUT
 * COOL = output PWM_PIN_1
 * WARM = output PWM_PIN_2
 * int tempSetting 
 * int tempValue
 */
void outputPWM(){
  switch (setting){
    case COOL:
      // surface cooling
      analogWrite( PWM_PIN_1, PWM_VALUE);
      analogWrite( PWM_PIN_2, 0);
    break;
    case WARM: 
      // surface warming
      analogWrite( PWM_PIN_1, 0);
      analogWrite( PWM_PIN_2, PWM_VALUE);
    break;
    case NORMAL:
    default:
      // don't output
      analogWrite( PWM_PIN_1, 0);
      analogWrite( PWM_PIN_2, 0);
  }
}
