// Using GroveConnectors
#define GROVE_R1 PA2 // Right 1
#define GROVE_R2 PA3 // Right 2
#define GROVE_L1 PA7 // Left 1
#define GROVE_L2 PB2 // Left 2

// Using Serial I/O
// ATTiny44 is not available Serial
// Alternative SoftwareSerial Library
#include <SoftwareSerial.h>
SoftwareSerial softSerial(0,1); // RX, TX

// Variable value
int sensorValue_X;
int sensorValue_Y;
void setup() {
  // put your setup code here, to run once:
  pinMode(GROVE_R1,INPUT);
  pinMode(GROVE_R2,OUTPUT);
  pinMode(GROVE_L1,INPUT);
  pinMode(GROVE_L2,OUTPUT);
  softSerial.begin(19200);
}

void loop() {
  // read the value from the sensor:
  if(softSerial.available()){
    softSerial.read();
    // analogRead
    sensorValue_X = constrain(analogRead(GROVE_R1), 0, 254);
    sensorValue_Y = constrain(analogRead(GROVE_L1), 0, 254);      
    // write x value
    softSerial.write(sensorValue_X);
    // write y value
    softSerial.write(sensorValue_Y);
  }
  // wait 100 mill second
  delay(100);
}

