#include "TinyWireS.h"                  // wrapper class for I2C slave routines

#define I2C_SLAVE_ADDR  0x26            // i2c slave address (38)

#include <SoftwareSerial.h>                      
SoftwareSerial mySerial(3, 4); // RX, TX                      


void setup() {
  // put your setup code here, to run once:
    mySerial.begin(9600);
    TinyWireS.begin(I2C_SLAVE_ADDR);      // init I2C Slave mode
}

void loop() {
  if(mySerial.available() > 0){
    char chr = mySerial.read();
     mySerial.println(chr);
  }
  // put your main code here, to run repeatedly:
  delay(100);
  while (1 < TinyWireS.available()) { // loop through all but the last
    char c = TinyWireS.receive(); // receive byte as a character
    mySerial.print(c);         // print the character
  }
  int x = TinyWireS.receive();    // receive byte as an integer
  mySerial.println(x);         // print the integer
}
