/*Example sketch to control a stepper motor with A4988 stepper motor driver AccelStepper library and Arduino. More info: https://www.makerguides.com */
#include <AccelStepper.h>
//Define stepper motor connections
#define dirPin 4
#define stepPin 5

#define STATUS_STOP 0
#define STATUS_RIGHT 200
#define STATUS_LEFT -200

//Create stepper object
AccelStepper stepper(1,stepPin,dirPin); //motor interface type must be set to 1 when using a driver.

int state = 0;

void setup()
{
  Serial.begin(9600);    
  stepper.setMaxSpeed(1000); //maximum steps per second
  stepper.setAcceleration(30);
}
void loop()
{
  stepper.setSpeed(state); //steps per second          
  stepper.runSpeed(); //step the motor with constant speed as set by setSpeed()
  // receive Serial Communication
  if (Serial.available() > 0) {
    // read a Byte
    char readByte = Serial.read();

    switch (readByte){
      case 'l':
        state = STATUS_RIGHT; 
        break;
      case 'r':
        state = STATUS_LEFT; 
        break;
      case 's':
        state = STATUS_STOP; 
        break; 
      default:
        break;
    }    
  }
}
