import processing.serial.*;
import java.util.ArrayList;

// checkPort Flag
boolean isCheckPort = false;
int portNumber = 0;
// SerialClass object
Serial port;

ArrayList thermoValueArray = null;

// setupDisplay
void setup() {
  thermoValueArray = new ArrayList();
  size(800, 600);
  frameRate(2); // reflesh per 500ms
  String[] ports = Serial.list();
  if(isCheckPort){
    for(int i = 0; i < ports.length; i++){
      println(i + ": " + ports[i]);
    }
  }else{    
    // port
    port = new Serial(this, ports[portNumber], 19200);
  }
}

void draw() {
  drawInit();
  if(thermoValueArray.size() > 1){
    for(int i = 1; i < thermoValueArray.size() && i < 60; i++){
      line((i-1) * 10 + 100, 590 - (float)thermoValueArray.get(i-1) * 10, i * 10 + 100, 590 - (float)thermoValueArray.get(i) * 10);
    }
  }
}

// Initialize Display
void drawInit(){
  clear();
  background(255);
  // startLine
  line(100,10,100,590);
  // endLine
  line(700,10,700,590);
  // bottomLine
  line(100,590,700,590);
  // Vertical unit (°C)
  textSize(16);
  fill(0, 102, 153, 204);
  text("(°C)",30,20);
  //Vertical scale (temperature)
  for(int i = 0; i < 51; i++){
    if(i % 10 == 0){
      line(85,590 - (i * 10), 100, 590 - (i * 10));
      textSize(16);
      fill(0, 102, 153, 204);
      text(i,60,590 - (i * 10));
    }else if( i % 5 == 0){
      line(90,590 - (i * 10), 100, 590 - (i * 10));
    }else{
      line(95,590 - (i * 10), 100, 590 - (i * 10));
    }
  }
}


// serialEvent
void serialEvent(Serial port){
  if(port.available() >= 3){   
    byte[] vals = port.readBytes(3);
    println(vals[0]);
    println(vals[1]);
    float val = (vals[0] << 8) + (vals[1] & 0Xff);
    println(val/100); 
    if(vals[2] == '\n'){
      thermoValueArray.add(0,val/100);      
    }
  }
}
