
// Using GroveConnectors
#define GROVE_R1 PA2 // Right 1
#define GROVE_R2 PA3 // Right 2
#define GROVE_L1 PA7 // Left 1
#define GROVE_L2 PB2 // Left 2

// Using Serial I/O
// ATTiny44 is not available Serial
// Alternative SoftwareSerial Library
#include <SoftwareSerial.h>
SoftwareSerial softSerial(0,1); // RX, TX

// for reading GroveThermoSensorV1.2 value
const int B = 4275;               // B value of the thermistor
const int R0 = 100000;            // R0 = 100k

void setup() {
  // put your setup code here, to run once:
  pinMode(GROVE_L1,INPUT);
  pinMode(GROVE_R2,OUTPUT);
  softSerial.begin(19200);
}

void loop() {
  // read the value from the sensor:
  // analogRead
  int temperature = getTemperature(); 
  // write x value  
  
  // Convert from float type (4 bytes) to int type (2 bytes).
  // Multiply by 100 to use decimal places.
  softSerial.write((int16_t)(temperature * 100) >> 8);
  softSerial.write((int16_t)(temperature * 100) & 0xFF);
  softSerial.write('\n');
  // wait 100 mill second
  delay(500);
}

/**
 * calculate Temperature Value
 * return temperature -40 ~ +125 ℃
 */
float getTemperature(){
  // read the value
  int val = analogRead(GROVE_L1);
  float R = 1023.0/val-1.0;
  R = R0*R;
  float temperature = 1.0/(log(R/R0)/B+1/298.15)-273.15; // convert to temperature
  return temperature;
}
