#include <ESP8266WiFi.h>
#include <FirebaseArduino.h>


#include "WemoSwitch.h"
#include "WemoManager.h"
#include "CallbackFunction.h"

#define FIREBASE_HOST "your host"
#define FIREBASE_AUTH "your db scret"
#define WIFI_SSID "your wifi SSID"
#define WIFI_PASSWORD "Your wifi password"

const int ledPin = LED_BUILTIN;

WemoManager wemoManager;
WemoSwitch *light = NULL;

void lightOn();
void lightOff();

void setup() {
   WiFi.mode(WIFI_STA);
  WiFi.disconnect();
  delay(100);
  
  Serial.begin(115200);
  pinMode(ledPin, OUTPUT);
  digitalWrite(ledPin,HIGH);
  
  WiFi.begin(WIFI_SSID, WIFI_PASSWORD);
  Serial.print("connecting");
  while (WiFi.status() != WL_CONNECTED) {
    Serial.print(".");
    delay(500);
  }
  Serial.println();
  Serial.print("connected: ");
  Serial.println(WiFi.localIP());
  Firebase.begin(FIREBASE_HOST, FIREBASE_AUTH);
  
  wemoManager.begin();
  light = new WemoSwitch("Light", 80, lightOn, lightOff);
  wemoManager.addDevice(*light);
}

void loop() {
  
   wemoManager.serverLoop();
   
  if(Firebase.getInt("FABLight")==1)
  {
    Firebase.setInt("ESPStat", 1);
    digitalWrite(ledPin, LOW);
  }
  else
  {
    Firebase.setInt("ESPStat", 0);
    digitalWrite(ledPin, HIGH);
  }
  Serial.println(Firebase.getInt("FABLight"));
  delay(100);
}

void lightOn() {
    Serial.print("Switch 1 turn on ...");
    digitalWrite(ledPin, LOW);
    Firebase.setInt("ESPStat", 1);
    Firebase.setInt("FABLight", 1);
}

void lightOff() {
    Serial.print("Switch 1 turn off ...");
    digitalWrite(ledPin, HIGH);
    Firebase.setInt("ESPStat", 0);
     Firebase.setInt("FABLight",0);
}
