#include <FirebaseArduino.h>
#include <ESP8266WiFi.h>
int pixel[3][3];
int brig=50;
#include <Adafruit_NeoPixel.h>

#define FIREBASE_HOST "your host"
#define FIREBASE_AUTH "your db scret"
#define WIFI_SSID "your wifi SSID"
#define WIFI_PASSWORD "Your wifi password"

const int pixelPin = 5;
#define LED_COUNT  5
Adafruit_NeoPixel strip = Adafruit_NeoPixel(LED_COUNT, pixelPin, NEO_GRB + NEO_KHZ800);

void setup() {
  Serial.begin(9600);

  strip.begin();
  strip.setBrightness(brig); // 0 ... 255
  strip.show(); // Initialize all pixels to 'off'

  // connect to wifi.
  WiFi.begin(WIFI_SSID, WIFI_PASSWORD);
  Serial.print("connecting");
  while (WiFi.status() != WL_CONNECTED) {
    Serial.print(".");
    delay(500);
  }
  Serial.println();
  Serial.print("connected: ");
  Serial.println(WiFi.localIP());

  Firebase.begin(FIREBASE_HOST, FIREBASE_AUTH);
}


void loop() {
  FirebaseObject pixels = Firebase.get("NeoPixel");
  if (Firebase.failed()) {
      Serial.println("Firebase get failed");
      Serial.println(Firebase.error());
      return;
  }
  ////////////////////////////////////////////////////////////////////////////////
    brig=pixels.getInt(String("Brig"));
    pixel[0][1] = pixels.getInt(String("pixel1/blue"));
    pixel[0][2] = pixels.getInt(String("pixel1/green"));
    pixel[0][3] = pixels.getInt(String("pixel1/red"));
    
    Serial.println(pixel[0][1]);
    Serial.println(pixel[0][2]);
    Serial.println(pixel[0][3]);
    
    strip.setBrightness(brig);
    strip.setPixelColor(0, strip.Color(pixel[0][3], pixel[0][2], pixel[0][1]));
    strip.setPixelColor(1, strip.Color(pixel[0][3], pixel[0][2], pixel[0][1]));
    strip.setPixelColor(2, strip.Color(pixel[0][3], pixel[0][2], pixel[0][1]));
    strip.setPixelColor(3, strip.Color(pixel[0][3], pixel[0][2], pixel[0][1]));
    strip.setPixelColor(4, strip.Color(pixel[0][3], pixel[0][2], pixel[0][1]));
    strip.show();

   delay(200);
}
