# Final Project: E3 - EngraveCube

## Design
Inspired from the evolution of the media devices and personal computer ...
![](../assignments/img/w20/comp.jpg)
*Evolution of the species? From left to right: TV Brionvega 201, 1969 (design: Richard Sapper, Marco Zanuso); a NeXT Cube workstation, 1986 (design: Harmut Esslinger); Power Mac G4 Cube, 2000 (design: Jonathan Ive / Apple Design Team)*

"E3 - EngraveCube" is a little 6" Cube Engraver Machine.

The aesthetic design of the "E3 - EngraveCube" hereafter E3 is characterized by two main parts in PMMA, and mechanical parts are made in ABS, or PLA if you want, and making stable system that support motors, endstops, laser and mirrors:

<iframe src="https://myhub.autodesk360.com/ue28c369e/shares/public/SH7f1edQT22b515c761e536cf9f8583c441c?mode=embed" width="800" height="600" allowfullscreen="true" webkitallowfullscreen="true" mozallowfullscreen="true"  frameborder="0"></iframe>

<center>
[Download the Assembly.f3z archive](E3_Design/src/E3_018_001/Assembly.f3z)
</center>

### Upper Section - Lasercutting - PMMA 3mm
The upper part is only aesthetic and contains the electronics; this part, for the fabacademy release, is inspired by the graphic layout of the Fab15 conference,
![](img/fab15.png)
and I've made it in semitransparent red with images engraved on every side.
on the rear side you can find the holes for external components, such as power supply IN adapter, on/off switch and red RESET button.
After cloned the repo or downloaded the whole Project folder, you can find the files to engrave and cut in `E3_Design/AI/`. The parts to gluing needed to upper section are stored in `top_3mm.AI`, well remember to cut only ***3mm*** materials.
![](img/upperpag.JPG)
after jobs are finished and assembling pices with glue.
![](img/red.jpg)

![](img/aaa.jpg)

### Bottom Section - Lasercutting - PMMA OD3+ filter 3.175mm
The bottom part is a 250nm to 520nm Laser Shielding.

!!!warning
    Do not operate lasers without correct protective equipment and training. Laser Safety Shielding is not intended to replace laser protective eyewear (laser glasses or laser goggles) or other laser safety products that maybe required.

You can buy the filter panel [here](https://robosavvy.com/store/laser-shielding.html)
![](img/od3.jpg)

|| |
|:---|:---|
|Thickness: 	|1/8″ (0.125″) (3.175mm)|
|Weight: 	|12 oz|
|Wavelength Range:| 	250nm to 520nm|
|Visible Light Transmittance:|	>55%|
|Optical Density:|	3 (OD 3+)|
|Attenuation:|	10-3 < N% < 10-4|

You can find the files to cut in `E3_Design/AI/`. The parts to gluing needed to bottom section are stored in `bottom_uvplex_3.175mm.ai`, well remember to cut only ***1/8"*** materials.
![](img/filter.JPG)
![](img/000.jpg)

### Mechanical Parts - 3D Printing - ABS or PLA
Inside [Assembly.f3z archive](E3_Design/src/E3_018_001/Assembly.f3z) in `E3_Design/src/E3_018_001/` folder you can find and export in ***.STL*** the following parts:
####Main Support
The main support is used to mount the two unipolar ***28BYJ-48-5V*** stepper motors, the two ***endstop switches*** and the ***laser source***.
![](img/3dp1.JPG)
![](img/3dp1a.JPG)
####Mirror Holders
This part must be printed x2 and is used to mount the two molibdenum mirrors
![](img/3dp2.JPG)

I've designed the pieces to 3D print without supports, saving time and material
![](img/3dp.JPG)

### Assemby the parts
At this point I've produced the necessary mechanical parts to assembly the machine.
Proceeding as you see below:
![](img/mount.JPG)
![](img/mount1.jpg)
![](img/mount2.JPG)
![](img/mount3.JPG)

Final results
![](img/001.jpg)

## Electronic Design and Production
Here I want show you how to make connection after you have produced the main board. The main documentation on this topic is in [E3_ElectronicDesign](../E3_ElectronicDesign/E3_ElectronicDesign/) folder.

Well, here the table connections:
![](img/conn.jpg)

## DOWNLOAD
<center>
[Download the Project E3 archive](files/E3.zip)
</center>
