# E3 - Autorun
To allow the automatic start of the web control interface, I use the system manager [systemd](https://wiki.archlinux.org/index.php/Systemd_(Italiano)).

## E&#179;-WebUI run on system boot
Below I describe the steps to follow to activate the autorun at boot. <br> **Read the instructions to the end before proceeding**.

1. Copy _unit file_ `engravecube.service` in system directory `/etc/systemd/system/`
```
 sudo cp engravecube.service /etc/systemd/system/
```
2. Make _unit file_ runnable
```
chmod 777 /etc/systemd/system/engravecube.service
```
3. Enable the autorun E&#179;-WebUI such as system service.
```
sudo systemctl enable engravecube
```


If all has been done correctly the E&#179;-WebUI will be started as a service and automatically restarted at each reboot.

!!!note "Note_1"
    The `engravecube.service` _unit file_  was prepared with the idea that the E&#179;-WebUI application is placed (along with the E&#179;-Sender and E&#179;-PostProcessor) in the `/usr/bin/engraveCube/` directory. See the installation guide for more details.

!!!note "Note_2"
    ~~ The _unit file_ `engravecube.service` was prepared with the idea that the E&#179;-WebUI application is performed as **User pi**[^e8abd3c5] (`User=pi Group=pi`).~~

[^e8abd3c5]: ~~Run WebUi as _pi_ to remedy the incorrect installation of python dependencies (see `requirements.txt` file) that have been installed in the user's home-directory instead of globally to all users.~~
Problem solved by logging in as _root_ (`sudo su`) and going to manually install` pip install <package> `the missing packages (_Flask-WTF_)

## Start/Stop/Restart E&#179; control service
Once the system manager _Systemd_ has been configured, the web control interface will be automatically started at boot time. However, I can check the execution of the service through the `service` utility.

To **manually start** the E&#179;-WebUI service I use the command
```
sudo service engravecube start
```

To **stop** the E&#179;-WebUI service I use the command
```
sudo service engravecube stop
```

To **restart** the E&#179;-WebUI service I use the command
```
sudo service engravecube restart
```

To know the E&#179;-WebUI service status I use the command
```
sudo service engravecube status
```

To disable the service so that it is no longer automatically run at boot
```
sudo systemctl disable engravecube
```

## Edit unit file.
In case of modification to the _unit file_ you need to update the _Systemd_ system manager configuration through the command:

```
sudo systemctl daemon-reload
```

## References and links
* [Systemd (Italiano)](https://wiki.archlinux.org/index.php/Systemd_(Italiano))
* [Understanding Systemd Units and Unit Files ](https://www.digitalocean.com/community/tutorials/understanding-systemd-units-and-unit-files)
