# Configure Serial connection

First of all I've made a Sender object to communicate with Serial:

``` python
# Creating Sender object
        try:
            sender = E3Sender.E3Sender("/dev/ttyS0", 9600)
        except Exception as e:
            flash(e)
            return render_template('engraveForm.html', title='Engrave', form=form)
```

I also noticed sometimes UART is disabled in kernel. The enable it you need to check in `/boot/config.txt` the line `enable_uart`

If it’s set to 0 like follow

```
enable_uart=0
```

You need to change to 1 as follow

```
enable_uart=1
```
And reboot of course!

In alternative you can use `raspi-config` and enable UART but disabling the console, as follows:
![s0](s0.JPG)
![s0](s0-2.JPG)
![s0](s0-3.JPG)
![s0](s0-4.JPG)

Now you can find the ttyS0 port in /dev
```
pi@engravecube:/ $ ls /dev
autofs           loop7               ram6     tty20  tty46      urandom
block            loop-control        ram7     tty21  tty47      vchiq
btrfs-control    mapper              ram8     tty22  tty48      vcio
bus              mem                 ram9     tty23  tty49      vc-mem
cachefiles       memory_bandwidth    random   tty24  tty5       vcs
char             mmcblk0             raw      tty25  tty50      vcs1
console          mmcblk0p1           rfkill   tty26  tty51      vcs2
cpu_dma_latency  mmcblk0p2           serial0  tty27  tty52      vcs3
cuse             mqueue              serial1  tty28  tty53      vcs4
disk             net                 shm      tty29  tty54      vcs5
fb0              network_latency     snd      tty3   tty55      vcs6
fd               network_throughput  stderr   tty30  tty56      vcsa
full             null                stdin    tty31  tty57      vcsa1
fuse             ppp                 stdout   tty32  tty58      vcsa2
gpiochip0        ptmx                tty      tty33  tty59      vcsa3
gpiomem          pts                 tty0     tty34  tty6       vcsa4
hwrng            ram0                tty1     tty35  tty60      vcsa5
initctl          ram1                tty10    tty36  tty61      vcsa6
input            ram10               tty11    tty37  tty62      vcsm
kmsg             ram11               tty12    tty38  tty63      vhci
log              ram12               tty13    tty39  tty7       watchdog
loop0            ram13               tty14    tty4   tty8       watchdog0
loop1            ram14               tty15    tty40  tty9       zero
loop2            ram15               tty16    tty41  ttyAMA0
loop3            ram2                tty17    tty42  ttyprintk
loop4            ram3                tty18    tty43  ttyS0
loop5            ram4                tty19    tty44  uhid
loop6            ram5                tty2     tty45  uinput
pi@engravecube:/ $
```
