from time import gmtime, strftime
import time,serial, sys
#Imports libraries for OpenCV Python3
import cv2
import numpy as np
#Imports libraries for Gtk3
import gi
gi.require_version('Gtk', '3.0')
from gi.repository import Gtk, Gdk, GLib, GdkPixbuf
#Serial Communication
global ser
ser = serial.Serial()
def mySerialport():

    if (len(sys.argv) != 3):
        print ("command line: Week16_using_Glade_GTK_and_Python_to_make_Terminal_GUI.glade.py serial_port speed")
        sys.exit()
    port = sys.argv[1]
    speed = int(sys.argv[2])
    ser.port = port
    #ser.port = "COM2"
    ser.baudrate = speed
    ser.bytesize = serial.EIGHTBITS #number of bits per bytes
    ser.parity = serial.PARITY_NONE #set parity check: no parity
    ser.stopbits = serial.STOPBITS_ONE #number of stop bits
    #ser.timeout = None          #block read
    ser.timeout = 1            #non-block read
    #ser.timeout = 2              #timeout block read
    ser.xonxoff = False     #disable software flow control
    ser.rtscts = False     #disable hardware (RTS/CTS) flow control
    ser.dsrdtr = False       #disable hardware (DSR/DTR) flow control
    ser.writeTimeout = 2     #timeout for write
                            #possible timeout values:
                            #    1. None: wait forever, block call
                            #    2. 0: non-blocking mode, return immediately
                            #    3. x, x is bigger than 0, float allowed, timeout block call

def myOpenSerialPort():
    ser.open()

def myCloseSerialPort():
        ser.close()

mySerialport()
#Captures the video from the camera
cap = cv2.VideoCapture(1)
#This section pull the front-end gladefile for showing it
builder = Gtk.Builder()
builder.add_from_file("test8.glade")
#This is a flag of the grayscale button
ethidiumbromide = False
sybrsafe = False
gelred = False
recordimage = False
#Makes a handler for toggle button
class Handler:
    def onDeleteWindow(self, *args):
        Gtk.main_quit(*args)

    def toggleEthidiumBromide(self, *args):
        global ethidiumbromide
        ethidiumbromide = ~ ethidiumbromide

    def toggleSYBRSafe(self, *args):
        global sybrsafe
        sybrsafe = ~ sybrsafe

    def toggleGelRed(self, *args):
        global gelred
        gelred = ~ gelred

    def on_CaptureButton_clicked(self, *args):
        global recordimage
        recordimage = ~ recordimage

    def on_less_light_clicked(self, *args):
        ser.write(b'-')     # write a string

    def on_more_light_clicked(self, *args):
        ser.write(b'+')     # write a string


window = builder.get_object("window1")
image = builder.get_object("image")
window.show_all()
builder.connect_signals(Handler())
myOpenSerialPort()

def show_frame(*args):
    ret, frame = cap.read()

    if ethidiumbromide:
        hsv = cv2.cvtColor(frame, cv2.COLOR_BGR2HSV)
        lower = np.array([17, 15, 100])
        upper = np.array([50, 56, 200])
        mask = cv2.inRange(frame, lower, upper)
        frame = cv2.bitwise_and(frame, frame, mask = mask)
    elif sybrsafe:
        hsv = cv2.cvtColor(frame, cv2.COLOR_BGR2HSV)
        lower = np.array([86, 31, 4])
        upper = np.array([220, 88, 50])
        mask = cv2.inRange(frame, lower, upper)
        frame = cv2.bitwise_and(frame, frame, mask = mask)
    elif gelred:
        hsv = cv2.cvtColor(frame, cv2.COLOR_BGR2HSV)
        lower = np.array([25, 146, 190])
        upper = np.array([62, 174, 250])
        mask = cv2.inRange(frame, lower, upper)
        frame = cv2.bitwise_and(frame, frame, mask = mask)

    global recordimage
    if recordimage:
        path = "Image Capture" + strftime("%Y-%m-%d %H:%M:%S", gmtime()) + ".png"
        cv2.imwrite(path, frame)
        recordimage = ~ recordimage

    frame = cv2.cvtColor(frame, cv2.COLOR_BGR2RGB)
    pb = GdkPixbuf.Pixbuf.new_from_data(frame.tostring(),
                                        GdkPixbuf.Colorspace.RGB,
                                        False,
                                        8,
                                        frame.shape[1],
                                        frame.shape[0],
                                        frame.shape[2]*frame.shape[1])
    image.set_from_pixbuf(pb.copy())
    return True

GLib.idle_add(show_frame)
Gtk.main()
