// button_polling.c
//
// 115200 baud nasty messages on button press + led blinking
//
// set lfuse to 0xDE for 16 MHz xtal
//
// Nicolas De Coster
// 2018-03-15
//
// Based on Neil Gershenfeld's  hello.ftdi.44.echo.interrupt.c
//
// (c) Massachusetts Institute of Technology 2010
// This work may be reproduced, modified, distributed,
// performed, and displayed for any purpose. Copyright is
// retained and must be preserved. The work is provided
// as is; no warranty is provided, and users accept all
// liability.
//

#define F_CPU 16000000UL

#include <stdio.h>
#include <stdint.h>
#include <avr/io.h>
#include <util/delay.h>
#include <avr/pgmspace.h>
#include <inttypes.h>

#define output(directions,pin) (directions |= pin) // set port direction for output
#define input(directions,pin) (directions &= (~pin)) //set port direction for input
#define set(port,pin) (port |= pin) // set port pin
#define clear(port,pin) (port &= (~pin)) // clear port pin
#define toggle(port,pin) (port ^= pin) // toggle port pin
#define pin_test(pins,pin) (pins & pin) // test for port pin
#define bit_test(byte,bit) (byte & (1 << bit)) // test for bit set
#define bit_delay_time 8.5 // bit delay for 115200 with overhead
#define bit_delay() _delay_us(bit_delay_time) // RS232 bit delay
#define half_bit_delay() _delay_us(bit_delay_time/2) // RS232 half bit delay
#define char_delay() _delay_ms(10) // char delay

#define max_buffer 25


//Pins definitions
#define serial_port PORTD
#define serial_direction DDRD
#define serial_pins PIND
#define serial_pin_in (1 << PD0)
#define serial_pin_out (1 << PD1)

#define led_port PORTB
#define led_direction DDRB
#define led_pins PINB
#define led_pin (1 << PB5)
#define led PB5

#define switch_port PORTB
#define switch_direction DDRB
#define switch_pins PINB
#define switch_pin (1 << PB0)
#define switchIn PB0
//end Pins Definitions


void get_char(volatile unsigned char *pins, unsigned char pin, char *rxbyte) {
	//
	// read character into rxbyte on pins pin
	//    assumes line driver (inverts bits)
	//
	*rxbyte = 0;
	while (pin_test(*pins,pin))
	//
	// wait for start bit
	//
	;
	//
	// delay to middle of first data bit
	//
	half_bit_delay();
	bit_delay();
	//
	// unrolled loop to read data bits
	//
	if pin_test(*pins,pin)
	*rxbyte |= (1 << 0);
	else
	*rxbyte |= (0 << 0);
	bit_delay();
	if pin_test(*pins,pin)
	*rxbyte |= (1 << 1);
	else
	*rxbyte |= (0 << 1);
	bit_delay();
	if pin_test(*pins,pin)
	*rxbyte |= (1 << 2);
	else
	*rxbyte |= (0 << 2);
	bit_delay();
	if pin_test(*pins,pin)
	*rxbyte |= (1 << 3);
	else
	*rxbyte |= (0 << 3);
	bit_delay();
	if pin_test(*pins,pin)
	*rxbyte |= (1 << 4);
	else
	*rxbyte |= (0 << 4);
	bit_delay();
	if pin_test(*pins,pin)
	*rxbyte |= (1 << 5);
	else
	*rxbyte |= (0 << 5);
	bit_delay();
	if pin_test(*pins,pin)
	*rxbyte |= (1 << 6);
	else
	*rxbyte |= (0 << 6);
	bit_delay();
	if pin_test(*pins,pin)
	*rxbyte |= (1 << 7);
	else
	*rxbyte |= (0 << 7);
	//
	// wait for stop bit
	//
	bit_delay();
	half_bit_delay();
}


void put_char(volatile unsigned char *port, unsigned char pin, char txchar) {
	//
	// send character in txchar on port pin
	//    assumes line driver (inverts bits)
	//
	// start bit
	//
	clear(*port,pin);
	bit_delay();
	//
	// unrolled loop to write data bits
	//
	if bit_test(txchar,0)
	set(*port,pin);
	else
	clear(*port,pin);
	bit_delay();
	if bit_test(txchar,1)
	set(*port,pin);
	else
	clear(*port,pin);
	bit_delay();
	if bit_test(txchar,2)
	set(*port,pin);
	else
	clear(*port,pin);
	bit_delay();
	if bit_test(txchar,3)
	set(*port,pin);
	else
	clear(*port,pin);
	bit_delay();
	if bit_test(txchar,4)
	set(*port,pin);
	else
	clear(*port,pin);
	bit_delay();
	if bit_test(txchar,5)
	set(*port,pin);
	else
	clear(*port,pin);
	bit_delay();
	if bit_test(txchar,6)
	set(*port,pin);
	else
	clear(*port,pin);
	bit_delay();
	if bit_test(txchar,7)
	set(*port,pin);
	else
	clear(*port,pin);
	bit_delay();
	//
	// stop bit
	//
	set(*port,pin);
	bit_delay();
}

void put_string(volatile unsigned char *port, unsigned char pin, char *str) {
	//
	// print a null-terminated string
	//
	static int index;
	index = 0;
	do {
		put_char(port, pin, str[index]);
		++index;
	} while (str[index] != 0);
}

int main(void) {
	//
	// main
	//
	
	static uint32_t res;
	static uint32_t resPot;
	//
	// set clock divider to /1
	//
	CLKPR = (1 << CLKPCE);
	CLKPR = (0 << CLKPS3) | (0 << CLKPS2) | (0 << CLKPS1) | (0 << CLKPS0);
	//
	// initialize output pins
	//
	set(serial_port, serial_pin_out);
	output(serial_direction, serial_pin_out);
	
	
	set(switch_port, switch_pin);
	input(switch_direction, switch_pin);
	switch_port = 0; // make sure PORTB is high impedance and will not source
	
	set(led_port, led_pin);
	output(led_direction, led_pin);
	
	//
	// init A/D
	//
	//ADMUX = (1 << REFS1) | (1 << REFS0) // Vref = 1.1V
	ADMUX = (0 << REFS1) | (0 << REFS0) // Vref = Vcc
	| (0 << ADLAR) // right adjust
	| (0 << MUX3) | (0 << MUX2) | (0 << MUX1) | (0 << MUX0); // ADC0 (pin PC0)
	ADCSRA = (1 << ADEN) // enable
	| (1 << ADPS2) | (1 << ADPS1) | (1 << ADPS0); // prescaler /128
	
	//
	// main loop
	//
	while (1) {		
		
		//// Pressure read
		
		//
		// select channel
		//
		ADMUX = (0 << MUX0); // ADC0 (pin PC0)
		//
		// initiate conversion
		//
		ADCSRA |= (1 << ADSC);
		//
		// wait for completion
		//
		while (ADCSRA & (1 << ADSC))
		;
		//
		// get result
		//
		res=ADC;
		
		
		///// Potentiometer read
		
		//
		// select channel
		//
		ADMUX = (1 << MUX0); // ADC1 (pin PC1)
		//
		// initiate conversion
		//
		ADCSRA |= (1 << ADSC);
		//
		// wait for completion
		//
		while (ADCSRA & (1 << ADSC))
		;
		//
		// get result
		//
		resPot=ADC;
		
		///// Switch read
		
		if (~switch_pins & (1 << switchIn)) {
			put_string(&serial_port, serial_pin_out, "Switch ON");
			put_char(&serial_port, serial_pin_out, '\"');
			char_delay();
			put_char(&serial_port, serial_pin_out, 10); // new line
		}
		else{
			put_string(&serial_port, serial_pin_out, "Switch OFF");
			put_char(&serial_port, serial_pin_out, '\"');
			char_delay();
			put_char(&serial_port, serial_pin_out, 10); // new line	
		}
		
		//
		// send result
		//
		char str[11]; //11 bytes: 10 for the digits, 1 for the null character
		snprintf(str, sizeof str, "%lu", (unsigned long)res);  //float to string
		char strPot[11]; //11 bytes: 10 for the digits, 1 for the null character
		snprintf(strPot, sizeof strPot, "%lu", (unsigned long)resPot);  //float to string
		
		put_string(&serial_port, serial_pin_out, "Pressure ADV value: ");
		put_string(&serial_port, serial_pin_out, str);
		put_char(&serial_port, serial_pin_out, '\"');
		char_delay();
		put_char(&serial_port, serial_pin_out, 10); // new line
		
		put_string(&serial_port, serial_pin_out, "Pressure pot value: ");
		put_string(&serial_port, serial_pin_out, strPot);
		put_char(&serial_port, serial_pin_out, '\"');
		char_delay();
		put_char(&serial_port, serial_pin_out, 10); // new line
		toggle(led_port, led_pin);
		_delay_ms(500);
	}
}