PROJECT=$(patsubst %.c,%,$(wildcard *.c))
SOURCES=$(PROJECT).c
MMCU=atmega328p
AVRDUDE_PARTNO=m328p
F_CPU = 16000000
L_FUSE=0xDE

CFLAGS=-mmcu=$(MMCU) -Wall -Os -DF_CPU=$(F_CPU)

$(PROJECT).hex: $(PROJECT).out
	avr-objcopy -O ihex $(PROJECT).out $(PROJECT).c.hex;\
	avr-size --mcu=$(MMCU) --format=avr $(PROJECT).out

$(PROJECT).out: $(SOURCES)
	avr-gcc $(CFLAGS) -I./ -o $(PROJECT).out $(SOURCES)

program-bsd: $(PROJECT).hex
	avrdude -p $(AVRDUDE_PARTNO) -c bsd -U flash:w:$(PROJECT).c.hex

program-dasa: $(PROJECT).hex
	avrdude -p $(AVRDUDE_PARTNO) -P /dev/ttyUSB0 -c dasa -U flash:w:$(PROJECT).c.hex

program-avrisp2: $(PROJECT).hex
	avrdude -p $(AVRDUDE_PARTNO) -P usb -c avrisp2 -U flash:w:$(PROJECT).c.hex

program-avrisp2-fuses: $(PROJECT).hex
	avrdude -p $(AVRDUDE_PARTNO) -P usb -c avrisp2 -U lfuse:w:$(L_FUSE):m

program-usbtiny: $(PROJECT).hex
	avrdude -p $(AVRDUDE_PARTNO) -P usb -c usbtiny -U flash:w:$(PROJECT).c.hex

program-usbtiny-fuses: $(PROJECT).hex
	avrdude -p $(AVRDUDE_PARTNO) -P usb -c usbtiny -U lfuse:w:$(L_FUSE):m

program-dragon: $(PROJECT).hex
	avrdude -p $(AVRDUDE_PARTNO) -P usb -c dragon_isp -U flash:w:$(PROJECT).c.hex

program-ice: $(PROJECT).hex
	avrdude -p $(AVRDUDE_PARTNO) -P usb -c atmelice_isp -U flash:w:$(PROJECT).c.hex

program-ice-fuses: $(PROJECT).hex
	avrdude -p $(AVRDUDE_PARTNO) -P usb -c atmelice_isp -U lfuse:w:$(L_FUSE):m

clean:
	rm -f $(PROJECT).c.hex $(PROJECT).out