#include <Wire.h>
#include <Adafruit_RGBLCDShield.h>
#include <utility/Adafruit_MCP23017.h>




/////////PINS///////

int sensorPin1 = A3;    // input pin for the pressure sensor 1
int sensorPin2 = A2;    // input pin for the pressure sensor 1
int sensorPin3 = A1;    // input pin for the pressure sensor 1
int pwmPin1 = 9;    // pwm connected to digital pin 9
int pwmPin2 = 10;    // pwm connected to digital pin 10
int pwmPin3 = 11;    // pwm connected to digital pin 11


////////VARIABLES/////

//Sensors
int sensorValue1 = 0;  // variable to store the value coming from the sensor 1
int sensorValue2 = 0;  // variable to store the value coming from the sensor 1
int sensorValue3 = 0;  // variable to store the value coming from the sensor 1
int sensorBuffer1 =0;  // variable to store the added values of the sensor
int sensorBuffer2 =0;  // variable to store the added values of the sensor
int sensorBuffer3 =0;  // variable to store the added values of the sensor
int sensorAvg1 =0;  // variable to store the average value of the sensor
int sensorAvg2 =0;  // variable to store the average value of the sensor
int sensorAvg3 =0;  // variable to store the average value of the sensor
//PWM
int dutyCycle1=100; //Duty cycle of PWM1  (0 to 255)
int dutyCycle2=100; //Duty cycle of PWM2  (0 to 255)
int dutyCycle3=100; //Duty cycle of PWM3  (0 to 255)
//Others
int countloop=0; 
int countloopMax=100; //Incremented at each loop, to average the pressure



/////////LCD/////////


Adafruit_RGBLCDShield lcd = Adafruit_RGBLCDShield();
// These #defines make it easy to set the backlight color of LCD
#define WHITE 0x7


void setup() {
  Serial.begin(9600);
  //PWM
  setPwmFrequency(9, 1024); // freq: 30 Hz if 1024
  setPwmFrequency(10, 1024); // freq: 30 Hz if 1024
  setPwmFrequency(11, 1024); // freq: 30 Hz if 1024 - Paired with pin3 - may cause the finction milli and delay to not work
  
  // set up the LCD's number of columns and rows: 
  lcd.begin(16, 2);
  // LCD - not variable display
  lcd.print("P1:");
  lcd.setCursor(8,0);
  lcd.print("P2:");
  lcd.setBacklight(WHITE);

}

void loop() {
  //Pressure sensor
  sensorValue1 = analogRead(sensorPin1); // read the value from the sensor:
  sensorValue2 = analogRead(sensorPin2); // read the value from the sensor:
  sensorValue3 = analogRead(sensorPin3); // read the value from the sensor:
 
  sensorBuffer1 += sensorValue1; //To make an average afterwards
  sensorBuffer2 += sensorValue2;
  sensorBuffer3 += sensorValue3;


  countloop=countloop+1;
  if(countloop == countloopMax){

    countloop=0; // reinit countloop


    //Pressure average
    sensorAvg1 = int(sensorBuffer1/countloopMax);
    sensorAvg2 = int(sensorBuffer2/countloopMax);
    sensorAvg3 = int(sensorBuffer3/countloopMax);

    sensorBuffer1=0;
    sensorBuffer2=0;
    sensorBuffer3=0;

    //LCD
    lcd.setCursor(4,0);
    lcd.print(sensorAvg1);
    lcd.print(" ");
    lcd.setCursor(12,0);
    lcd.print(sensorAvg2);
    lcd.print(" ");

    //Serial communication with the python interface: sending data
    Serial.println("P1");
    Serial.println(sensorAvg1);
    Serial.println(sensorAvg2);
    Serial.println(sensorAvg3);
    Serial.println(millis());
    }

    //Serial communication with the python interface: receiving data
    if(Serial.available()) {
      String incomingString = Serial.readStringUntil('\n');
      if(incomingString=="PWM"){
        String pwm1=Serial.readStringUntil('\n');
        String pwm2=Serial.readStringUntil('\n'); 
        String pwm3=Serial.readStringUntil('\n'); 

        dutyCycle1=pwm1.toInt();
        dutyCycle2=pwm2.toInt();
        dutyCycle3=pwm3.toInt();
      }
    }

  

  //Update PWM
  analogWrite(pwmPin1, dutyCycle1);
  analogWrite(pwmPin2, dutyCycle2);
  analogWrite(pwmPin3, dutyCycle3);
}



void setPwmFrequency(int pin, int divisor) {
 /**
 * Divides a given PWM pin frequency by a divisor.
 *
 * The resulting frequency is equal to the base frequency divided by
 * the given divisor:
 *   - Base frequencies:
 *      o The base frequency for pins 3, 9, 10, and 11 is 31250 Hz.
 *      o The base frequency for pins 5 and 6 is 62500 Hz.
 *   - Divisors:
 *      o The divisors available on pins 5, 6, 9 and 10 are: 1, 8, 64,
 *        256, and 1024.
 *      o The divisors available on pins 3 and 11 are: 1, 8, 32, 64,
 *        128, 256, and 1024.
 *
 * PWM frequencies are tied together in pairs of pins. If one in a
 * pair is changed, the other is also changed to match:
 *   - Pins 5 and 6 are paired on timer0
 *   - Pins 9 and 10 are paired on timer1
 *   - Pins 3 and 11 are paired on timer2
 *
 * Note that this function will have side effects on anything else
 * that uses timers:
 *   - Changes on pins 3, 5, 6, or 11 may cause the delay() and
 *     millis() functions to stop working. Other timing-related
 *     functions may also be affected.
 *   - Changes on pins 9 or 10 will cause the Servo library to function
 *     incorrectly.
 *
 * Thanks to macegr of the Arduino forums for his documentation of the
 * PWM frequency divisors. His post can be viewed at:
 *   https://forum.arduino.cc/index.php?topic=16612#msg121031
 */
  byte mode;
  if(pin == 5 || pin == 6 || pin == 9 || pin == 10) {
    switch(divisor) {
      case 1: mode = 0x01; break;
      case 8: mode = 0x02; break;
      case 64: mode = 0x03; break;
      case 256: mode = 0x04; break;
      case 1024: mode = 0x05; break;
      default: return;
    }
    if(pin == 5 || pin == 6) {
      TCCR0B = TCCR0B & 0b11111000 | mode;
    } else {
      TCCR1B = TCCR1B & 0b11111000 | mode;
    }
  } else if(pin == 3 || pin == 11) {
    switch(divisor) {
      case 1: mode = 0x01; break;
      case 8: mode = 0x02; break;
      case 32: mode = 0x03; break;
      case 64: mode = 0x04; break;
      case 128: mode = 0x05; break;
      case 256: mode = 0x06; break;
      case 1024: mode = 0x07; break;
      default: return;
    }
    TCCR2B = TCCR2B & 0b11111000 | mode;
  }
}
