/********************************************************************/
// First we include the libraries
#include <OneWire.h> 
#include <DallasTemperature.h>
#include <SoftwareSerial.h>

SoftwareSerial mySerial(0,1); // RX, TX
/********************************************************************/
// Data wire is plugged into pin 5 on the Arduino 
#define ONE_WIRE_BUS 5
/********************************************************************/
// Setup a oneWire instance to communicate with any OneWire devices  
// (not just Maxim/Dallas temperature ICs) 
OneWire oneWire(ONE_WIRE_BUS); 
/********************************************************************/
// Pass our oneWire reference to Dallas Temperature. 
DallasTemperature sensors(&oneWire);
/********************************************************************/ 



void setup() 
{ 

 // start serial port 
  mySerial.begin(9600);

  delay (100);

 // Start up the library 
 sensors.begin();


}

void loop() 
{ 

 // call sensors.requestTemperatures() to issue a global temperature 
 // request to all devices on the bus 
/********************************************************************/ 
sensors.requestTemperatures(); // Send the command to get temperature readings  
  float t = sensors.getTempCByIndex(0);
  mySerial.print("Temperature is: ");
  mySerial.println(t); // Why "byIndex"?
// Serial.println(sensors.getTempCByIndex(0));
   // You can have more than one DS18B20 on the same bus.  
   // 0 refers to the first IC on the wire 
  //delay(4000); 
/********************************************************************/
  float u = sensors.getTempCByIndex(1);// 
  float d = ((17.502*t)/(240.97+t)); // Equation for Humidity
  float e = 2.7183;
  float g = 6.112*(pow(e,d));
  float j = ((17.502*u)/(240.97+u));
  float k = 2.7183;
  float m = 6.112*(pow(k,j));
  float n = (m-(0.6687*(1+0.00115*u)*(t-u)))/g*100; //Humidity upto 2 digit

mySerial.print("Humidity is: ");
 mySerial.println(n); // Why "byIndex"?
 mySerial.println("Hello, world?");

}
