#!/anaconda3/envs/py37/bin/python

import glob
import serial
import math

AR_PORT = "usbmodem"
FTDI_PORT = "SLAB_USBtoUART"
BAUD = 9600
TIMEOUT = 1


def serial_ports():
    """ Returns available ports """
    ports = glob.glob('/dev/tty.*')  # MacOS port pre-fix
    result = []
    for port in ports:
        try:
            s = serial.Serial(port)
            s.close()
            result.append(port)
        except (OSError, serial.SerialException):
            pass
    return result


def establish_connection(port):
    """ Returns serial connection & status"""
    print("Connecting to {}".format(port))
    device_ser = serial.Serial(port,  BAUD, timeout=TIMEOUT)
    return device_ser


def main(device_port=FTDI_PORT):
    # -- Get available ports & connect to Arduino --
    ports = serial_ports()
    device_found = False

    for port in ports:
        if device_port in port:
            device_found = True
            device_ser = establish_connection(port)
            break
        else:
            pass

    if not device_found:
        print("Device not found, PORT name is wrong? Device not connected?")
        exit()
    else:
        print("Connection established")

    device_ser.reset_input_buffer()
    while True:
        ser_bytes = device_ser.readline()
        # value_as_int = ser_bytes
        # value_as_int = ser_bytes.decode("utf-8")[:-1]
        value_as_int = math.log10(int(ser_bytes.decode("utf-8")[:-1]))
        print(value_as_int)


if __name__ == '__main__':
    # -- Call main() function --
    main()
    # -- END -- #
