#!/anaconda3/envs/py37/bin/python

import glob
import serial
import matplotlib.pyplot as plt
from drawnow import drawnow
import math

AR_PORT = "usbmodem"
FTDI_PORT = "SLAB_USBtoUART"
BAUD = 9600
TIMEOUT = 1

plt.ion()
SCALE = 100
values = []


def fill_values():
    for i in range(SCALE):
        values.append(0)


def plotValues():
    plt.title('Serial value from Arduino')
    plt.grid(True)
    plt.ylabel('Values')
    plt.plot(values, 'rx-', label='values')
    plt.legend(loc='upper right')


def serial_ports():
    """ Returns available ports """
    ports = glob.glob('/dev/tty.*')  # MacOS port pre-fix
    result = []
    for port in ports:
        try:
            s = serial.Serial(port)
            s.close()
            result.append(port)
        except (OSError, serial.SerialException):
            pass
    return result


def establish_connection(port):
    """ Returns serial connection & status"""
    print("Connecting to {}".format(port))
    device_ser = serial.Serial(port,  BAUD, timeout=TIMEOUT)
    return device_ser


def main(device_port=FTDI_PORT):
    # -- Get available ports & connect to Arduino --
    ports = serial_ports()
    device_found = False

    for port in ports:
        if device_port in port:
            device_found = True
            device_ser = establish_connection(port)
            break
        else:
            pass

    if not device_found:
        print("Device not found, PORT name is wrong? Device not connected?")
        exit()
    else:
        print("Connection established")

    device_ser.reset_input_buffer()
    fill_values()
    while True:
        try:
            ser_bytes = device_ser.readline()
            value_as_int = math.log10(int(ser_bytes.decode("utf-8")[:-1]))
            values.append(value_as_int)
            values.pop(0)
            drawnow(plotValues)
        except KeyboardInterrupt:
            print("\t Keyboard Interrupt")
            break


if __name__ == '__main__':
    main()
    # -- END -- #
