#!/anaconda3/envs/py37/bin/python

import math
import glob

import serial
from kivy.clock import Clock
from kivy.app import App
from kivy.uix.label import Label
from kivy.uix.floatlayout import FloatLayout

AR_PORT = "usbmodem"
FTDI_PORT = "SLAB_USBtoUART"
BAUD = 9600
TIMEOUT = 1


class Body(FloatLayout):
    def __init__(self, **kwargs):
        super(Body, self).__init__(**kwargs)

        refresh_rate = 0.01
        Clock.schedule_interval(self.timer, refresh_rate)

        self.lbl = Label(font_size='60sp', markup=True)
        self.add_widget(self.lbl)

    def timer(self, dt):
        ser_bytes = ser_device.readline()
        try:
            ser_int = int(math.log2(int(ser_bytes.decode("utf-8")[:-1])))
            if ser_int <= 10:
                self.lbl.text = "OFF"
            elif ser_int > 10:
                self.lbl.text = "[color=F30087]ON[/color]"
        except ValueError:
            pass


class Gui(App):
    def build(self):
        return Body()


def serial_ports():
    """ Returns available ports """
    ports = glob.glob('/dev/tty.*')  # MacOS port pre-fix
    result = []
    for port in ports:
        try:
            s = serial.Serial(port)
            s.close()
            result.append(port)
        except (OSError, serial.SerialException):
            pass
    return result


def establish_connection(port):
    """ Returns serial connection & status"""
    print("Connecting to {}".format(port))
    device_ser = serial.Serial(port,  BAUD, timeout=TIMEOUT)
    return device_ser


def setup(device_port=FTDI_PORT):
    # -- Get available ports & connect to Arduino --
    ports = serial_ports()
    device_found = False

    for port in ports:
        if device_port in port:
            device_found = True
            ser_device = establish_connection(port)
            break
        else:
            pass

    if not device_found:
        print("Device not found, PORT name is wrong? Device not connected?")
        exit()
    else:
        print("Connection established")

    ser_device.reset_input_buffer()
    return ser_device


if __name__ == '__main__':
    ser_device = setup()
    Gui().run()
    ser_device.close()
