int adcPin = 12;  // ADC pin
int ledPin = 4;   // LED pin (duuuuuh)
int ADC_Max = 4095; // for mapping the values later

const int threshold = 1320;
const int hysteresis = 100;

int val; // declare variable to be used later

void setup() {
  Serial.begin(9600);
  pinMode(ledPin, OUTPUT);
}

void loop() {
  val = analogRead(adcPin);             // read the value of the potentiometer (value between 0 and 4095)
  var = map(val, 0, ADC_Max, 0, 3333);  // mapping the value so that it represent actual voltage it is receiving
  Serial.println(val);
  
  if (val >= 1320 + hysteresis / 2) {
    digitalWrite(ledPin, HIGH);
  } else if (val >= 1320 - hysteresis / 2){
    digitalWrite(ledPin, LOW);
  }
  
  // wait 200ms before going it again - I'm using a high value on purpose so that the graph doesn't scroll past too fast
  delay(200);
}
