// number of readings we want to take into account
const int numReadings = 10;

int readings[numReadings];      // the readings from the analog input
int readIndex = 0;              // the index of the current reading
int total = 0;                  // the running total
int average = 0;                // the average

int adcPin = 14;
int outPin = 16;


void setup() {
  
  // initialize serial communication with computer:
  Serial.begin(9600);
  
  pinMode(outPin, OUTPUT);
  pinMode(adcPin, INPUT);
  
  // initialize all the readings to 0:
  for (int thisReading = 0; thisReading < numReadings; thisReading++) {
    readings[thisReading] = 0;
  }
}

void loop() {
  digitalWrite(outPin, HIGH);

  // subtract the last reading:
  total = total - readings[readIndex];
  
  // read from the sensor:
  readings[readIndex] = analogRead(adcPin);
  
  // add the reading to the total:
  total = total + readings[readIndex];
  
  // advance to the next position in the array:
  readIndex = readIndex + 1;

  // if we're at the end of the array...
  if (readIndex >= numReadings) {
    // ...wrap around to the beginning:
    readIndex = 0;
  }

  // calculate the average:
  average = total / numReadings;
  
  // send it to the computer as ASCII digits
  Serial.println(average);
  delay(10);        // delay in between reads for stability
}
