int adcPin = 12;  // ADC pin
int ledPin = 4;   // LED pin (duuuuuh)
int ADC_Max = 4095; // for mapping the values later

int val; // declare variable to be used later

void setup() {
  Serial.begin(115200);
  pinMode(ledPin, OUTPUT);
}

void loop() {
  val = analogRead(adcPin);             // read the value of the potentiometer (value between 0 and 4095)
  val = map(val, 0, ADC_Max, 0, 3333);  // mapping the value so that it represent actual voltage it is receiving
  Serial.println(val);
  
  // if it is above a specific value, in my case I read in the graph above
  if (val > 1320) {

    // then switch LED on
    digitalWrite(ledPin, HIGH);
  } else {
    // otherwise off
    digitalWrite(ledPin, LOW);
  }
  
  // wait 200ms before going it again - I'm using a high value on purpose so that the graph doesn't scroll past too fast
  delay(200);
}
