import processing.serial.*;

class Button{
  private color c;
  private int posX;
  private int posY;
  private int b_width;
  private int b_height;
  private boolean expanded;
  private int comport;
  
  Button(color button_color, int positionX, int positionY, int button_width, int button_height) {
   c = button_color;
   posX = positionX;
   posY = positionY;
   b_width = button_width;
   b_height = button_height;
   expanded = false;
   comport = 0;
  }
  
  public int getX(){
    return posX;
  }
  public int getY(){
    return posY;
  }
  public int getWidth(){
    return b_width;
  }
  public int getHeight(){
    return b_height;
  }  
  public void display(){
    rect(getX(), getY(), getWidth(), getHeight());
    fill(getColor());
  }
  public color getColor(){
    return c;
  }
  public void setColor(){
    c += 250;
    display(); 
  }
  public boolean isExpanded(){
    return expanded;
  }
  public void toggleExpanded(){
    if(isExpanded() == false){
      this.expanded = true;
    }else{
      this.expanded = false;
    }
  }
  public int getComport(){
    return comport;
  }
  public void setComport(int comport){
    this.comport = comport;
  }
  public void expand(){
    
    for(int i = 0; i < Serial.list().length; i++){
      fill(255);
      rect(getX(), 10 + getHeight() + i * getHeight(), getWidth(), getHeight());
      textSize(13);
      fill(0);
      text(Serial.list()[i], 5 + getX(), 25 + getHeight() + i * getHeight());
    }
  }
  
}

class Slider{
 private int xStart;
 private int xEnd;
 private int yStart;
 private int yEnd;
 private int x_width;
 private int y_height;
 private int currentValue;
 private int minValue;
 private int maxValue;
 
 Slider(int positionXstart, int positionYstart, int positionXend, int positionYend){
   xStart = positionXstart;
   xEnd = positionXend;
   yStart = positionYstart;
   yEnd = positionYend;
   x_width = positionXend - positionXstart;
   y_height = positionYend - positionYstart;;
   currentValue = 0;
   minValue = 0;
   maxValue = 255;
 }
 
 public int getxStart() {return xStart;}
 public void setxStart(int xStart) {this.xStart = xStart;}
 
 public int getxEnd() {return xEnd;}
 public void setxEnd(int xEnd) {this.xEnd = xEnd;}
    
 public int getyStart() {return yStart;}
 public void setyStart(int yStart) {this.yStart = yStart;}
   
 public int getyEnd() {return yEnd;}
 public void setyEnd(int yEnd) {this.yEnd = yEnd;}
 
 public int getHeight() {return y_height;}
 public int getWidth() {return x_width;}
 
 public int getCurrentValue(){
   return currentValue;
 }
 public void setCurrentValue(int value){
   currentValue = value;
 }
 
 public void move(int starting){
   currentValue = mouseX;
   
   //innenteil übermalen
   fill(235);
   stroke(235);
   rect(getxStart() + 1, getyStart() + 1, getWidth() + 10 - 1, getHeight() - 1);
   
   //außenteil übermalen
   stroke(0);
   rect(getxStart(), getyStart() ,getWidth() + 10 ,getHeight());
   
   if(starting == 0){
     //sliderelement neu malen
     fill(255);
     stroke(0);
     rect(getCurrentValue(),getyStart() + 2,8,8);
   }
   if(mouseX-55 >= 0){
     currentValue = mouseX-55;
   }else {
     currentValue = 0;
   }
 }
 
}



Serial myPort;

Button myButton;
Button expansion;
Slider sliderRed;
Slider sliderGreen;
Slider sliderBlue;
int selection;
int[] data = new int[49];
String newdata = new String();
String portName;






void setup() {
  size(1000,640);
  printscreen();
  portName = Serial.list()[0];
  myPort = new Serial(this, portName, 9600);
 
}

void printscreen(){
 background(235);
  
  color c = color(255, 255, 255);
  myButton = new Button(c, 140, 12, 90, 20);
  myButton.display();
  textSize(13);
  fill(0);
  text("COM... ", 145, 28);
  
  textSize(20);
  fill(0);
  text("Connect to ", 10, 30);
  
  line(10,40, 350,40);
  
  PImage img;
  img = loadImage(".\\img2.png");
  image(img, 80,100);
  
  textSize(9);
  fill(255,0,0);
  text("R",40,405);
  sliderRed = new Slider(52,394,307,406);
  sliderRed.move(1);
  
  textSize(9);
  fill(50,255,50);
  text("G",40,424);
  sliderGreen = new Slider(52,414,307,426);
  sliderGreen.move(1);
  
  textSize(9);
  fill(0,0,255);
  text("B",40,444);
  sliderBlue = new Slider(52,434,307,446);
  sliderBlue.move(1);
  
  rect(150, 460,40,20);
  textSize(13);
  fill(0);
  text("send", 154,475); 
}
          
void draw() {
  
   /*
  while (myPort.available() > 0) {
    int inByte = myPort.read();
    
    //print(inByte);
    counter++;
    if(counter > 64){
      counter = 0;
      //println();
    }
    
  }
  */
  
}

void mousePressed(){
  if(mouseX >= myButton.getX() && mouseX <= myButton.getX() + myButton.getWidth()){
    if(mouseY >= myButton.getY() && mouseY <= myButton.getY()+myButton.getHeight()){
      myButton.expand();
      myButton.toggleExpanded();
    }
  }
  
 
  if(myButton.isExpanded() == true){
    if(mouseX >= 140 && mouseX <= 230){
      if(mouseY >= 32  && mouseY <= 52){
        //COM[0]
        portName = Serial.list()[0];
        printscreen();
        myButton.display();
      }else if(mouseY >= 52  && mouseY <= 72){
        //COM[1]
        portName = Serial.list()[1];
        printscreen();
        myButton.display();
      }else if(mouseY >= 72  && mouseY <= 92){
        //COM[2]
        portName = Serial.list()[2];
        printscreen();
        myButton.display();
      }
    }
  }
  
  
  if(mouseX >= 52 && mouseX <= 307){
    if(mouseY >= 394 && mouseY <= 406){
      sliderRed.move(0);
    }
  }
  
  if(mouseX >= 52 && mouseX <= 307){
    if(mouseY >= 414 && mouseY <= 426){
      sliderGreen.move(0);
    }
  }
  
  if(mouseX >= 52 && mouseX <= 307){
    if(mouseY >= 434 && mouseY <= 446){
      sliderBlue.move(0);
    }
  }
  
 
  if(mouseX >= 150 && mouseX <= 190){
    if(mouseY >= 460 && mouseY <= 480){
      data[0] = -300;
      fill(sliderRed.getCurrentValue(), sliderGreen.getCurrentValue(), sliderBlue.getCurrentValue());
      rect(150, 460,40,20);
      textSize(13);
      fill(255);
      text("send", 154,475);
      
      
      
      for(int i = 0; i < 48; i++){
        myPort.write(data[i]);
        print(data[i] + " ");
      }
      println();
      
    }
  }
  
  /* ----------------------------------------------------------
           Reihe 1
 ------------------------------------------------------------*/
 
  //img (80,100)
  if(mouseX >= 80 && mouseX <= 100){
    if(mouseY >= 100 && mouseY <= 120){
      calculate(0,0,15);
    }
  }
  
  if(mouseX >= 80+45 && mouseX <= 80+65){
    if(mouseY >= 100+0 && mouseY <= 100+20){
      calculate(45,0,16);
    }
  }
  
  if(mouseX >= 80+90 && mouseX <= 80+110){
    if(mouseY >= 100+0 && mouseY <= 100+20){
      calculate(90,0,1);
    }
  }
  
  if(mouseX >= 80+135 && mouseX <= 80+155){
    if(mouseY >= 100+0 && mouseY <= 100+20){
      calculate(135,0,2);
    }
  }
  
  if(mouseX >= 80+180 && mouseX <= 80+200){
    if(mouseY >= 100+0 && mouseY <= 100+20){
      calculate(180,0,3);
    }
  }
  
  /* ----------------------------------------------------------
          Reihe 2
 ------------------------------------------------------------*/
  if(mouseX >= 80+0 && mouseX <= 80+20){
    if(mouseY >= 100+45 && mouseY <= 100+65){
      calculate(0,45,14);
    }
  }
  
   if(mouseX >= 80+180 && mouseX <= 80+200){
    if(mouseY >= 100+45 && mouseY <= 100+65){
      calculate(180,45,4);
    }
  }
  
  /* ----------------------------------------------------------
          Reihe 3
 ------------------------------------------------------------*/
  if(mouseX >= 80+0 && mouseX <= 80+20){
    if(mouseY >= 100+90 && mouseY <= 100+110){
      calculate(0,90,13);
    }
  }
  
  if(mouseX >= 80+180 && mouseX <= 80+200){
    if(mouseY >= 100+90 && mouseY <= 100+110){
      calculate(180,90,5);
    }
  }
 
  /* ----------------------------------------------------------
          Reihe 4
 ------------------------------------------------------------*/
  if(mouseX >= 80+0 && mouseX <= 80+20){
    if(mouseY >= 100+135 && mouseY <= 100+155){
      calculate(0,135,12);
    }
  }
  
  if(mouseX >= 80+180 && mouseX <= 80+200){
    if(mouseY >= 100+135 && mouseY <= 100+155){
      calculate(180,135,6);
    }
  }
  
  /* ----------------------------------------------------------
           Reihe 5
 ------------------------------------------------------------*/
  //img (80,100)
  if(mouseX >= 80+0 && mouseX <= 100+20){
    if(mouseY >= 100+180 && mouseY <= 120+200){
       calculate(0,180,11);
    }
  }
  
  if(mouseX >= 80+45 && mouseX <= 80+65){
    if(mouseY >= 100+180 && mouseY <= 100+200){
      calculate(45,180,10);
    }
  }
  
  if(mouseX >= 80+90 && mouseX <= 80+110){
    if(mouseY >= 100+180 && mouseY <= 100+200){
       calculate(90,180,9);
    }
  }
  
  if(mouseX >= 80+135 && mouseX <= 80+155){
    if(mouseY >= 100+180 && mouseY <= 100+200){
      calculate(135,180,8);
    }
  }
  
  if(mouseX >= 80+180 && mouseX <= 80+200){
    if(mouseY >= 100+180 && mouseY <= 100+200){
      calculate(180,180,7);
    }
  }
  
  
  /*
  if(mouseX >= && mouseX <= ){
    if(mouseY >= && mouseY <= ){
      
    }
  }
  */
}

void addToString(int a, int b, int c){
  newdata += a;
  newdata += ",";
  newdata += b;
  newdata += ",";
  newdata += c;
  newdata += ",";
}

void calculate(int x, int y, int lastPosition){
 
   lastPosition *= 3;
   data[lastPosition-2] = sliderRed.getCurrentValue();
   data[lastPosition-1] = sliderGreen.getCurrentValue();
   data[lastPosition] = sliderBlue.getCurrentValue();
   fill(sliderRed.getCurrentValue(), sliderGreen.getCurrentValue(), sliderBlue.getCurrentValue());
   circle(90+x,110+y,20);
 }
