#include <SimpleDHT.h>
#include "FastLED.h"
#include <SPI.h>
#include <Adafruit_GFX.h>
#include <Adafruit_PCD8544.h>

Adafruit_PCD8544 display = Adafruit_PCD8544(5, 4, 3);

#define NUM_LEDS 16
#define DATA_PIN 7

CRGB leds[NUM_LEDS];

#define DHT11PIN 2
SimpleDHT11 dht11(DHT11PIN);

#define MQ_PIN A0

int i = 1;

void setup() {
  Serial.begin(9600);

  FastLED.addLeds<NEOPIXEL, DATA_PIN>(leds, NUM_LEDS);
  pinMode(MQ_PIN, INPUT);
  leds[0] = CRGB::White;
  FastLED.show();

  display.begin();
  display.setContrast(60);
  display.clearDisplay();
}

void loop()
{
  Serial.println();

  int moValue = analogRead(MQ_PIN);

  byte temperature = 0;
  byte humidity = 0;
  int err = SimpleDHTErrSuccess;
  if ((err = dht11.read(&temperature, &humidity, NULL)) != SimpleDHTErrSuccess) {
    Serial.print("Read DHT11 failed, err="); Serial.println(err);delay(1000);
    return;
  }

  Serial.print((int)temperature); Serial.print(" *C, ");
  Serial.print((int)humidity); Serial.println(" H");

  Serial.print("MO ");
  Serial.println(moValue);

  display.clearDisplay();
  display.setTextSize(1);
  display.setTextColor(BLACK);
  display.setCursor(15, 0);
  display.print("PIXLAMP");
  display.drawFastHLine(0,10,83,BLACK);
  display.print("                  ");
  display.print("Temp: ");
  display.print((int)temperature);
  display.println(" C");
  display.print("Hum: ");
  display.print((int)humidity);
  display.println(" %");
  display.print("MO: ");
  display.print((int)(((float)moValue / 1024.0) * 100));
  display.println(" %");
  display.display();
  delay(500);

  if(moValue > 302) {
    for(int j = 0; j < 16; j++) {
      leds[j] = CRGB::Red;
    }
  } else {
    if(i < NUM_LEDS) {
      leds[i] = CRGB::White;
     
    } else {
      leds[0] = CRGB::White;
     
      i = 0;
    }
  }

  i++;

  FastLED.show(); // apply the function on led strip
}
