//****************************************************
// Ulises Gordillo Zapana - FabAcademy 2020
//****************************************************
#define pin_tx      8
#define pin_buz     7
#define pin_x_left  6
#define pin_x_right 5
#define pin_y_back  4
#define pin_y_front 3
#define pin_z_down  2
#define pin_z_up    1
#define pin_pot     0

// Include Resource
#include <SoftwareSerial.h>
SoftwareSerial SerialPort(pin_buz, pin_tx); // RX, TX

int dato_serial=0;
#define   estado_z_up     1
#define   estado_z_down   2
#define   estado_y_front  3
#define   estado_y_back   4
#define   estado_x_right  5
#define   estado_x_left   6
#define   estado_reposo   7
byte estado = estado_reposo;
// Function SETUP
void setup() {
  SerialPort.begin(115200);
  pinMode(pin_buz,OUTPUT);
  digitalWrite(pin_buz,LOW);
  pinMode(pin_x_left,INPUT);
  pinMode(pin_x_right,INPUT);
  pinMode(pin_y_back,INPUT);
  pinMode(pin_y_front,INPUT);
  pinMode(pin_z_down,INPUT);
  pinMode(pin_z_up,INPUT);  
}

// Function LOOP
void loop(){
  if (!digitalRead(pin_z_up)){    estado = estado_z_up;}
  if (!digitalRead(pin_z_down)){  estado = estado_z_down;}
  if (!digitalRead(pin_y_front)){ estado = estado_y_front;}
  if (!digitalRead(pin_y_back)){  estado = estado_y_back;}
  if (!digitalRead(pin_x_right)){ estado = estado_x_right;}
  if (!digitalRead(pin_x_left)){  estado = estado_x_left;}
  if (estado != estado_reposo){
    SerialPort.println("G91");
    SerialPort.print("G1 F");
    SerialPort.print(2*analogRead(A0));
    SerialPort.print(" ");
    switch (estado){
      case estado_z_up:     SerialPort.println("Z1");   break;
      case estado_z_down:   SerialPort.println("Z-1");   break;
      case estado_y_front:  SerialPort.println("Y1");   break;
      case estado_y_back:   SerialPort.println("Y-1");   break;
      case estado_x_right:  SerialPort.println("X1");   break;
      case estado_x_left:   SerialPort.println("X-1");   break;
    }
    digitalWrite(pin_buz,HIGH);
    delay(100);
    digitalWrite(pin_buz,LOW);
    estado = estado_reposo;
  }
}
