#include <DFRobotDFPlayerMini.h>

// --- DFPlayer Serial Setup ---
#define DFPLAYER_RX_PIN 44  // Connect to DFPlayer TX
#define DFPLAYER_TX_PIN 43  // Connect to DFPlayer RX
HardwareSerial& dfSerial = Serial1;

DFRobotDFPlayerMini myDFPlayer;

// --- IR Breakbeam Sensor Setup ---
#define SENSORPIN 4    // IR breakbeam sensor connected to D4 (GPIO 4)
int sensorState = 0, lastState = 0;

// --- Trigger Pin to Arduino ---
#define UNOTRIGGER_PIN 2  // XIAO GPIO2 to Arduino D12 (SPN EN)

// --- Constants ---
const int DFPLAYER_VOLUME = 30;
const int NUM_TRACKS = 7;

void setup() {
  Serial.begin(115200);

  // Set IR sensor pin as input with internal pull-up resistor
  pinMode(SENSORPIN, INPUT_PULLUP);

  // Initialize Serial1 for DFPlayer communication
  dfSerial.begin(9600, SERIAL_8N1, DFPLAYER_RX_PIN, DFPLAYER_TX_PIN);
  delay(100);

  // Initialize DFPlayer
  if (!myDFPlayer.begin(dfSerial, true, true)) {
    Serial.println("DFPlayer Mini not found!");
    while (true) delay(500);
  }

  myDFPlayer.volume(DFPLAYER_VOLUME);
  Serial.print("Volume set to ");
  Serial.println(DFPLAYER_VOLUME);

  // Initialize trigger pin to Arduino
  pinMode(UNOTRIGGER_PIN, OUTPUT);
  digitalWrite(UNOTRIGGER_PIN, LOW); // Start LOW
}

void loop() {
  // Read the state of the IR breakbeam sensor
  sensorState = digitalRead(SENSORPIN);

  // If the beam is broken (LOW), play a random track and trigger Arduino
  if (sensorState == LOW && lastState == HIGH) {
    int track = random(1, NUM_TRACKS + 1); // Choose a random track between 1 and 7
    Serial.print("IR Beam Broken! Playing random track: ");
    Serial.println(track);
    myDFPlayer.play(track);  // Play the random track

    // Trigger Arduino Uno to spin motor
    digitalWrite(UNOTRIGGER_PIN, HIGH); // Send HIGH pulse
    delay(100); // 100 ms delay to trigger Uno
    digitalWrite(UNOTRIGGER_PIN, LOW); // Reset to LOW

    // Wait for DFPlayer to finish playing the track
    while (myDFPlayer.isPlaying()) {
      delay(100);  // Check if it's still playing
    }

    // Wait for motor to finish spinning (4 seconds)
    delay(4000);

    // Delay to prevent multiple detections in rapid succession
    delay(1000);  // Give time before the next trigger
  }

  // Print state change to serial
  if (sensorState == HIGH && lastState == LOW) {
    Serial.println("IR Beam Unbroken");
  }

  // Update lastState for next loop
  lastState = sensorState;

  delay(10); // Short delay to stabilize sensor reading
}
