const int stepX = 2;  // X.STEP (Arduino D2)
const int dirX  = 5;  // X.DIR (Arduino D5)
const int enPin = 8;  // Enable pin (Arduino D8)
const int triggerPin = 12; // SPN EN (Arduino D12) or CoolEn (D12)
const int stepDelay = 800; // Step delay (in microseconds for motor speed)

void setup() {
  pinMode(triggerPin, INPUT); // Trigger from XIAO ESP32-S3
  pinMode(stepX, OUTPUT);     // Motor step signal
  pinMode(dirX, OUTPUT);      // Motor direction signal
  pinMode(enPin, OUTPUT);     // Motor enable pin

  digitalWrite(dirX, HIGH);  // Set direction to clockwise (or counterclockwise)
  digitalWrite(enPin, LOW);  // Enable the motor driver
}

void loop() {
  if (digitalRead(triggerPin) == HIGH) {  // Check if XIAO triggered
    unsigned long startTime = millis();
    while (millis() - startTime < 4000) {  // Run motor for 4 seconds
      digitalWrite(stepX, HIGH);           // Step signal HIGH
      delayMicroseconds(stepDelay);        // Step pulse delay for motor speed
      digitalWrite(stepX, LOW);            // Step signal LOW
      delayMicroseconds(stepDelay);        // Step pulse delay for motor speed
    }
  }
}
