int servoPin = 0; // PWM pin required, dont worry about that if your using any board made in the past 15 years

void setup() {
  pinMode(servoPin, OUTPUT);
}

void loop() {
  // Sweep from 0 to 180 degreesw
  for (int i = 0; i <= 180; i++) {
    writeServo(i);
    delay(15);
  }

  // Sweep back from 180 to 0 degrees
  for (int i = 180; i >= 0; i--) {
    writeServo(i);
    delay(15);
  }
}

void writeServo(int angle) {
  int pulseWidth = map(angle, 0, 180, 500, 2500);
  // servo works by taking a pulse 500-2500 small seconds(I dont have the micro symbol)[pico seconds], and then the duration of that pulse is directly related to the angle it will end up at
  // ! the servo I used was the sg90s , which uses those specific timings, other servos will use different 
  // Send a 50 Hz signal (one pulse every 20ms), its just what most servos use, dont change this probably
  digitalWrite(servoPin, HIGH);
  delayMicroseconds(pulseWidth);
  digitalWrite(servoPin, LOW);
  delay(20 - (pulseWidth / 1000)); // total time between waves is 20ms minus the amount of time it needs to communicate the angle 
}
