#include "WifiCam.hpp"
#include <WiFi.h>
#include <ESPmDNS.h>

static const char* WIFI_SSID = "ATTsmith";
static const char* WIFI_PASS = "rolltide9172";
static const char* MDNS_HOSTNAME = "maestrocamera"; // Set the MDNS hostname

esp32cam::Resolution initialResolution;

WebServer server(80);

void
setup() {
  Serial.begin(115200);
  Serial.println();
  esp32cam::setLogger(Serial);
  delay(1000);

  WiFi.persistent(false);
  WiFi.mode(WIFI_STA);
  WiFi.begin(WIFI_SSID, WIFI_PASS);
  if (WiFi.waitForConnectResult() != WL_CONNECTED) {
    Serial.printf("WiFi failure %d\n", WiFi.status());
    delay(5000);
    ESP.restart();
  }
  Serial.println("WiFi connected");
  WiFi.setSleep(WIFI_PS_NONE);
  delay(1000);

    // Initialize MDNS
  if (!MDNS.begin(MDNS_HOSTNAME)) {
    Serial.println("Error setting up MDNS responder!");
    while (1) {
      delay(1000);
    }
  }
  Serial.println("mDNS responder started");
  MDNS.addService("http", "tcp", 80); // Advertise the HTTP service

  {
    using namespace esp32cam;

    initialResolution = Resolution::find(1024, 768);

    Config cfg;
    cfg.setPins(pins::XiaoSense);
    cfg.setResolution(initialResolution);
    cfg.setJpeg(80);

    bool ok = Camera.begin(cfg);
    if (!ok) {
      Serial.println("camera initialize failure");
      delay(5000);
      ESP.restart();
    }
    Serial.println("camera initialize success");
  }

  Serial.println("camera starting");
  Serial.print("http://");
  Serial.print(MDNS_HOSTNAME);
  Serial.println(".local"); // Print the MDNS address for easy access.

  addRequestHandlers();
  Serial.println("requests on");
  server.begin();
  Serial.println("server on");
}

void
loop() {
  server.handleClient();
}
